% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_data.R
\name{subset_data}
\alias{subset_data}
\title{Subset data to provide start and finish time windows}
\usage{
subset_data(data, start = NULL, stop = NULL, rezero = T,
  remove = T)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{start}{a single number indicating start time of new dataframe}

\item{stop}{a single number indicating end time of new dataframe}

\item{rezero}{logical, whether time should start from zero}

\item{remove}{logical, remove observations outside of start and stop}
}
\value{
a subsetted PupillometryR dataframe
}
\description{
subset_data can be used on a PupillometryR dataframe to subset the time into relevant chunks.
This, ideally should be one of the first runctions run, before anything analytical.
Use this to indicate a start and stop time to create a new resized dataframe.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
subset_data(Sdata, start = 100, stop = 10000, rezero = TRUE, remove = TRUE)
}
