% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_mean_pupil_size.R
\name{calculate_mean_pupil_size}
\alias{calculate_mean_pupil_size}
\title{Calculate a mean size across two pupils over time}
\usage{
calculate_mean_pupil_size(data, pupil1, pupil2)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil1}{column name indicating pupil size}

\item{pupil2}{column name indicating pupil size}
}
\value{
A PupillometryR dataframe with a mean pupil column
}
\description{
This function is useful when you have left and right eye eyetracking data, and a mean of the two would be useful.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data, pupil1 = RPupil, pupil2 = LPupil)
}
