#' Critical Values Matrix for the SQ Test
#'
#' @description This function stores critical values for the SQ test, covering up to 10 breaks and up to 100 regressors.
#' It is used by \code{get.cv.sq()} to return critical values based on the number of breaks under the null hypothesis and the number of regressors.
#'
#' @return A numeric matrix (400 x 10) of precomputed critical values 
#' corresponding to various break and regressor configurations.
#'
#'
#' @noRd

input.all.cv = function() 
{
  all.cv <- matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                     1.210592, 1.338982, 1.410205, 1.460535, 1.497571, 1.528086, 1.552713, 1.573415, 1.591775, 1.607729, 
                     1.343541, 1.464904, 1.532201, 1.57753, 1.61197, 1.640902, 1.663567, 1.683699, 1.699716, 1.715987, 
                     1.615452, 1.718203, 1.774801, 1.813229, 1.845833, 1.873373, 1.890529, 1.909965, 1.921867, 1.938264, 
                     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
                     1.338982, 1.459712, 1.52701, 1.572149, 1.606526, 1.634825, 1.658566, 1.677748, 1.694905, 1.711365, 
                     1.464144, 1.576454, 1.63894, 1.68199, 1.714847, 1.740424, 1.762519, 1.781132, 1.797149, 1.813103, 
                     1.717506, 1.816331, 1.874069, 1.912434, 1.93953, 1.962068, 1.9841, 2.003346, 2.019363, 2.030695, 
                     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
                     1.409825, 1.525807, 1.588989, 1.633432, 1.666036, 1.692752, 1.715417, 1.733776, 1.751186, 1.765747, 
                     1.529859, 1.637547, 1.696234, 1.738018, 1.769166, 1.7943, 1.817091, 1.836274, 1.851404, 1.866535, 
                     1.772332, 1.869827, 1.922437, 1.959283, 1.989734, 2.013032, 2.031391, 2.045573, 2.057285, 2.067161, 
                     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
                     1.459269, 1.570693, 1.632609, 1.675089, 1.7082, 1.734093, 1.755555, 1.773724, 1.789488, 1.804492, 
                     1.574681, 1.679331, 1.737955, 1.777903, 1.808354, 1.834121, 1.855203, 1.873879, 1.888693, 1.904774, 
                     1.811267, 1.907623, 1.957953, 1.997458, 2.026897, 2.046522, 2.062033, 2.076277, 2.091092, 2.100905, 
                     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
                     1.495988, 1.604563, 1.665466, 1.70801, 1.740107, 1.764988, 1.786576, 1.805252, 1.821649, 1.8364, 
                     1.609058, 1.712315, 1.76866, 1.809051, 1.840389, 1.865332, 1.886161, 1.90509, 1.919588, 1.933199, 
                     1.843617, 1.936175, 1.990241, 2.026137, 2.05127, 2.06944, 2.090269, 2.103184, 2.115212, 2.127178, 
                     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
                     1.5253, 1.632229, 1.692309, 1.733903, 1.765178, 1.789995, 1.8119, 1.829563, 1.846086, 1.859951, 
                     1.636218, 1.737828, 1.79373, 1.833741, 1.863623, 1.88825, 1.909902, 1.926299, 1.942379, 1.955484, 
                     1.866598, 1.957763, 2.012462, 2.045573, 2.069313, 2.092928, 2.108945, 2.122999, 2.136168, 2.149462, 
                     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
                     1.549484, 1.656476, 1.715797, 1.756884, 1.787906, 1.813672, 1.834184, 1.851848, 1.867358, 1.881729, 
                     1.660148, 1.76043, 1.817091, 1.855203, 1.885211, 1.910092, 1.929844, 1.947381, 1.962195, 1.977642, 
                     1.88768, 1.980175, 2.030695, 2.062349, 2.089952, 2.110338, 2.128507, 2.141802, 2.156426, 2.169721, 
                     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
                     1.570313, 1.675279, 1.734853, 1.776447, 1.807025, 1.830956, 1.851848, 1.869764, 1.885211, 1.900026, 
                     1.679584, 1.780182, 1.835071, 1.873373, 1.903761, 1.926235, 1.946558, 1.964094, 1.980808, 1.995749, 
                     1.90642, 1.998218, 2.045763, 2.077734, 2.104703, 2.124455, 2.141802, 2.157376, 2.172127, 2.184472, 
                     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
                     1.588736, 1.692436, 1.751566, 1.790818, 1.821966, 1.84634, 1.866409, 1.884262, 1.900342, 1.9137, 
                     1.696234, 1.79468, 1.850075, 1.88749, 1.916486, 1.941809, 1.960169, 1.979921, 1.996382, 2.009233, 
                     1.919271, 2.011956, 2.059184, 2.094131, 2.117808, 2.139143, 2.158769, 2.175166, 2.188967, 2.201059, 
                     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
                     1.604436, 1.707313, 1.765494, 1.806328, 1.835767, 1.859191, 1.880273, 1.89781, 1.91351, 1.926995, 
                     1.711492, 1.80981, 1.8628, 1.901735, 1.930984, 1.954471, 1.976123, 1.994609, 2.00898, 2.022148, 
                     1.933833, 2.024681, 2.0702, 2.105336, 2.131609, 2.152881, 2.172317, 2.187005, 2.202072, 2.212581, 
                     11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
                     1.619821, 1.721748, 1.779929, 1.81918, 1.848492, 1.872803, 1.892872, 1.911231, 1.925539, 1.9401, 
                     1.725483, 1.822409, 1.876475, 1.91427, 1.943392, 1.967639, 1.989671, 2.006891, 2.021895, 2.034114, 
                     1.945924, 2.03633, 2.084064, 2.117302, 2.143511, 2.166429, 2.184092, 2.199666, 2.212391, 2.225496, 
                     12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
                     1.632419, 1.734283, 1.790881, 1.830323, 1.859508, 1.884262, 1.90528, 1.921867, 1.938391, 1.951116, 
                     1.738398, 1.834121, 1.887617, 1.925666, 1.954914, 1.979288, 2.001636, 2.017337, 2.031835, 2.043927, 
                     1.957193, 2.045952, 2.094447, 2.126608, 2.152818, 2.175736, 2.193209, 2.207707, 2.219862, 2.233283, 
                     13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
                     1.644701, 1.745805, 1.802403, 1.841528, 1.870777, 1.895087, 1.9156, 1.933453, 1.948267, 1.961182, 
                     1.74973, 1.844947, 1.899076, 1.937188, 1.965677, 1.99081, 2.010436, 2.027086, 2.041584, 2.053486, 
                     1.968589, 2.055955, 2.103057, 2.136041, 2.16377, 2.185295, 2.203908, 2.217393, 2.230688, 2.243223, 
                     14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
                     1.65597, 1.755935, 1.813039, 1.851404, 1.88097, 1.905723, 1.925286, 1.943012, 1.95751, 1.971691, 
                     1.759607, 1.854633, 1.909142, 1.946178, 1.975553, 2.000497, 2.01911, 2.035317, 2.048865, 2.061526, 
                     1.977706, 2.063552, 2.111984, 2.14617, 2.17257, 2.194475, 2.211125, 2.227459, 2.241577, 2.2512, 
                     15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
                     1.665403, 1.765494, 1.822156, 1.859951, 1.889959, 1.91446, 1.935352, 1.951559, 1.96745, 1.980934, 
                     1.769356, 1.863686, 1.917562, 1.955421, 1.984543, 2.008157, 2.02772, 2.043547, 2.057285, 2.06944, 
                     1.987582, 2.071656, 2.119517, 2.152818, 2.179977, 2.201629, 2.218343, 2.235816, 2.248731, 2.25943, 
                     16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
                     1.675089, 1.775434, 1.830702, 1.869447, 1.899266, 1.922437, 1.943392, 1.959409, 1.975553, 1.989608, 
                     1.779422, 1.873246, 1.926425, 1.962891, 1.99309, 2.015374, 2.034747, 2.050194, 2.063742, 2.075644, 
                     1.995938, 2.077734, 2.125658, 2.160225, 2.186372, 2.208276, 2.227459, 2.24259, 2.255062, 2.265064, 
                     17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
                     1.684332, 1.783727, 1.839186, 1.877424, 1.907496, 1.9313, 1.950229, 1.967639, 1.98315, 1.997585, 
                     1.786956, 1.880843, 1.934972, 1.971248, 2.001573, 2.022781, 2.041774, 2.056905, 2.070263, 2.083431, 
                     2.003915, 2.085584, 2.132876, 2.166366, 2.192006, 2.213911, 2.231637, 2.247021, 2.260126, 2.270762, 
                     18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
                     1.692246, 1.790501, 1.84653, 1.884452, 1.914143, 1.938961, 1.957573, 1.975173, 1.990241, 2.004485, 
                     1.7943, 1.88768, 1.941809, 1.978212, 2.007018, 2.029556, 2.047345, 2.062983, 2.076088, 2.090015, 
                     2.009233, 2.092231, 2.13851, 2.172254, 2.19954, 2.218912, 2.238348, 2.252339, 2.264178, 2.275067, 
                     19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
                     1.700159, 1.798225, 1.853177, 1.891416, 1.920917, 1.945038, 1.96517, 1.981947, 1.997585, 2.009803, 
                     1.802213, 1.895404, 1.948267, 1.985429, 2.013095, 2.035823, 2.053929, 2.06944, 2.083431, 2.096916, 
                     2.015501, 2.099259, 2.145031, 2.179154, 2.205428, 2.227965, 2.244932, 2.259177, 2.270762, 2.285956, 
                     20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
                     1.70801, 1.805949, 1.859761, 1.898886, 1.928008, 1.951306, 1.971818, 1.988721, 2.004485, 2.016071, 
                     1.809621, 1.902495, 1.955104, 1.992203, 2.019933, 2.042344, 2.060577, 2.075138, 2.090649, 2.102677, 
                     2.022338, 2.104766, 2.150792, 2.184726, 2.211315, 2.233727, 2.250503, 2.263925, 2.275764, 2.291084, 
                     21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
                     1.715606, 1.812395, 1.867232, 1.904889, 1.93372, 1.957667, 1.977554, 1.993911, 2.008915, 2.021624, 
                     1.816161, 1.908301, 1.960609, 1.996971, 2.024507, 2.047513, 2.065105, 2.081345, 2.095348, 2.108587, 
                     2.026743, 2.111529, 2.156658, 2.190725, 2.21579, 2.23756, 2.257212, 2.271039, 2.28216, 2.291339, 
                     22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
                     1.722428, 1.820152, 1.873979, 1.911346, 1.940592, 1.964405, 1.983061, 2.00051, 2.014557, 2.028055, 
                     1.823773, 1.914693, 1.967917, 2.003638, 2.031676, 2.053569, 2.072939, 2.090223, 2.102678, 2.117219, 
                     2.034255, 2.119852, 2.164352, 2.197494, 2.222953, 2.243201, 2.258125, 2.273324, 2.288029, 2.300759, 
                     23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
                     1.7286, 1.825509, 1.879558, 1.916976, 1.944848, 1.968254, 1.987913, 2.004287, 2.018197, 2.030772, 
                     1.829204, 1.920261, 1.97195, 2.007572, 2.033852, 2.056026, 2.07471, 2.0898, 2.103659, 2.115465, 
                     2.036316, 2.117364, 2.163355, 2.194768, 2.219406, 2.240348, 2.256773, 2.272172, 2.284029, 2.294551, 
                     24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
                     1.736288, 1.832834, 1.887006, 1.923458, 1.950519, 1.974066, 1.992749, 2.008447, 2.02376, 2.036713, 
                     1.836301, 1.926732, 1.977051, 2.011625, 2.039313, 2.060933, 2.077691, 2.093533, 2.107593, 2.119631, 
                     2.04148, 2.121461, 2.169662, 2.204091, 2.228505, 2.25051, 2.269579, 2.281424, 2.297796, 2.310749, 
                     25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
                     1.742121, 1.836598, 1.891128, 1.928675, 1.95757, 1.981122, 2.000189, 2.017717, 2.032527, 2.045616, 
                     1.840493, 1.932162, 1.984836, 2.021023, 2.04847, 2.070708, 2.087646, 2.102728, 2.11695, 2.130718, 
                     2.051006, 2.132756, 2.179542, 2.211653, 2.235522, 2.252823, 2.271256, 2.283621, 2.297706, 2.307263, 
                     26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 
                     1.748736, 1.845072, 1.898535, 1.935088, 1.96404, 1.987185, 2.007169, 2.022841, 2.037402, 2.049487, 
                     1.84836, 1.938632, 1.990814, 2.026172, 2.053074, 2.076048, 2.094111, 2.108373, 2.122721, 2.135105, 
                     2.055721, 2.137795, 2.184084, 2.215684, 2.238572, 2.257318, 2.271965, 2.2899, 2.303564, 2.314496, 
                     27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 
                     1.753722, 1.848264, 1.902213, 1.940143, 1.968469, 1.991751, 2.009949, 2.026453, 2.0411, 2.053932, 
                     1.851936, 1.94329, 1.995221, 2.030084, 2.056958, 2.079998, 2.097188, 2.112723, 2.127168, 2.138345, 
                     2.060065, 2.140242, 2.184224, 2.218603, 2.243661, 2.261738, 2.278362, 2.292122, 2.301968, 2.313346, 
                     28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 
                     1.758384, 1.854017, 1.907737, 1.944263, 1.972308, 1.995003, 2.014603, 2.031644, 2.045551, 2.057205, 
                     1.857265, 1.947893, 1.99806, 2.034777, 2.060796, 2.082727, 2.09973, 2.116273, 2.129608, 2.14298, 
                     2.063624, 2.145426, 2.192383, 2.225623, 2.251184, 2.271969, 2.288742, 2.305744, 2.317474, 2.326873, 
                     29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 
                     1.7642, 1.85848, 1.912126, 1.949534, 1.976248, 1.998359, 2.017389, 2.0337, 2.047438, 2.060161, 
                     1.861923, 1.95334, 2.002056, 2.036854, 2.063097, 2.084918, 2.102969, 2.116997, 2.131895, 2.144182, 
                     2.06538, 2.146756, 2.193696, 2.224543, 2.249663, 2.269454, 2.288592, 2.302656, 2.317663, 2.329262, 
                     30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 
                     1.768602, 1.863028, 1.915426, 1.953251, 1.981431, 2.002686, 2.021909, 2.038066, 2.052535, 2.065074, 
                     1.866645, 1.957247, 2.005615, 2.041649, 2.068795, 2.089912, 2.10824, 2.125395, 2.139279, 2.151026, 
                     2.071551, 2.1533, 2.197395, 2.229605, 2.256131, 2.27842, 2.293337, 2.309459, 2.320621, 2.332781, 
                     31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 
                     1.774165, 1.867566, 1.920432, 1.956868, 1.98435, 2.007078, 2.026328, 2.043677, 2.058501, 2.071291, 
                     1.871042, 1.960377, 2.010423, 2.046498, 2.074177, 2.09592, 2.1134, 2.127207, 2.141965, 2.15528, 
                     2.076669, 2.157248, 2.201882, 2.233562, 2.258782, 2.281083, 2.295743, 2.31014, 2.323258, 2.33372, 
                     32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 
                     1.777955, 1.871295, 1.926048, 1.961789, 1.989681, 2.011882, 2.031645, 2.047436, 2.061914, 2.074672, 
                     1.875172, 1.965197, 2.014697, 2.050813, 2.078049, 2.098593, 2.11651, 2.133021, 2.145122, 2.158537, 
                     2.080519, 2.161163, 2.207536, 2.240056, 2.263821, 2.284615, 2.29925, 2.313727, 2.326829, 2.339462, 
                     33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 
                     1.78249, 1.875977, 1.928588, 1.964776, 1.992246, 2.015088, 2.033361, 2.050679, 2.064503, 2.076566, 
                     1.87959, 1.968329, 2.018462, 2.053724, 2.079612, 2.100722, 2.118099, 2.133775, 2.148137, 2.16005, 
                     2.081523, 2.161902, 2.20448, 2.239205, 2.263749, 2.279872, 2.298892, 2.312418, 2.32675, 2.336514, 
                     34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
                     1.786227, 1.880472, 1.932434, 1.97072, 1.99927, 2.021654, 2.039383, 2.054686, 2.069047, 2.08121, 
                     1.883727, 1.974003, 2.024566, 2.058055, 2.084436, 2.105906, 2.123893, 2.139995, 2.155412, 2.167803, 
                     2.087005, 2.170087, 2.216282, 2.248544, 2.271355, 2.291341, 2.305787, 2.320234, 2.332853, 2.345015, 
                     35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 
                     1.789248, 1.883527, 1.936229, 1.97305, 2.001451, 2.024686, 2.044203, 2.060604, 2.074736, 2.088267, 
                     1.887299, 1.97633, 2.028294, 2.063693, 2.091411, 2.114263, 2.131293, 2.146601, 2.162072, 2.1744, 
                     2.094336, 2.177079, 2.223002, 2.25411, 2.276634, 2.297272, 2.314274, 2.330211, 2.341336, 2.352817, 
                     36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
                     1.795504, 1.88871, 1.941275, 1.978222, 2.006548, 2.028952, 2.047714, 2.064118, 2.078608, 2.090452, 
                     1.892221, 1.981969, 2.032175, 2.067157, 2.09344, 2.115136, 2.132352, 2.147288, 2.159552, 2.171579, 
                     2.095693, 2.174514, 2.220842, 2.252155, 2.277887, 2.297042, 2.314101, 2.328461, 2.343999, 2.35228, 
                     37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
                     1.798827, 1.892353, 1.944913, 1.981051, 2.008035, 2.030618, 2.04958, 2.065222, 2.079909, 2.091753, 
                     1.895748, 1.98432, 2.033284, 2.068642, 2.09535, 2.117279, 2.135159, 2.15148, 2.165463, 2.176855, 
                     2.098091, 2.178842, 2.224737, 2.25826, 2.280818, 2.299779, 2.316629, 2.329756, 2.342657, 2.353245, 
                     38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
                     1.802683, 1.895199, 1.947316, 1.983292, 2.01016, 2.03193, 2.050728, 2.065974, 2.078925, 2.091609, 
                     1.898605, 1.986385, 2.035023, 2.069501, 2.09463, 2.116279, 2.132588, 2.147737, 2.161147, 2.172165, 
                     2.097191, 2.174484, 2.220367, 2.25516, 2.277872, 2.296984, 2.315033, 2.330038, 2.342843, 2.354223, 
                     39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 
                     1.806159, 1.8986, 1.951723, 1.987997, 2.01586, 2.03847, 2.057758, 2.073606, 2.08813, 2.099749, 
                     1.902156, 1.99146, 2.042003, 2.076488, 2.102933, 2.123963, 2.141927, 2.157055, 2.170881, 2.184429, 
                     2.105373, 2.186149, 2.229767, 2.263322, 2.287304, 2.30471, 2.319977, 2.332409, 2.343726, 2.355647, 
                     40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
                     1.811159, 1.903577, 1.955033, 1.991409, 2.018546, 2.040896, 2.059666, 2.075304, 2.089622, 2.102776, 
                     1.907112, 1.994676, 2.043961, 2.078861, 2.105886, 2.125864, 2.143851, 2.158952, 2.17336, 2.185575, 
                     2.108526, 2.1877, 2.234659, 2.270342, 2.29466, 2.312759, 2.330925, 2.344393, 2.35663, 2.368554, 
                     41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 
                     1.813944, 1.906084, 1.957651, 1.994666, 2.021614, 2.04356, 2.062078, 2.078161, 2.091182, 2.104095, 
                     1.909253, 1.997576, 2.046794, 2.081157, 2.107156, 2.128693, 2.146996, 2.161138, 2.175065, 2.187719, 
                     2.109097, 2.190479, 2.235751, 2.267721, 2.291026, 2.310579, 2.327567, 2.338755, 2.35085, 2.360076, 
                     42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 
                     1.816978, 1.908882, 1.960572, 1.997333, 2.024862, 2.047734, 2.066198, 2.08252, 2.095682, 2.107596, 
                     1.912375, 2.000909, 2.051144, 2.085223, 2.11084, 2.131154, 2.148848, 2.163798, 2.176565, 2.188645, 
                     2.113106, 2.190974, 2.236551, 2.267823, 2.291922, 2.31024, 2.328766, 2.342302, 2.353655, 2.365777, 
                     43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
                     1.820984, 1.91279, 1.964313, 2.0001, 2.028099, 2.051342, 2.069185, 2.085262, 2.099834, 2.111836, 
                     1.916122, 2.003753, 2.054874, 2.088233, 2.114947, 2.136203, 2.154528, 2.170003, 2.18315, 2.195333, 
                     2.117336, 2.198604, 2.245089, 2.274112, 2.298419, 2.318109, 2.33537, 2.347734, 2.358412, 2.369652, 
                     44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 
                     1.824723, 1.91677, 1.969183, 2.005405, 2.032707, 2.055181, 2.073719, 2.089309, 2.102436, 2.114342, 
                     1.920435, 2.008837, 2.057935, 2.092159, 2.117231, 2.138716, 2.155431, 2.170284, 2.185235, 2.197451, 
                     2.119539, 2.200069, 2.24457, 2.274238, 2.298864, 2.319205, 2.335319, 2.351665, 2.36361, 2.375108, 
                     45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 
                     1.827344, 1.91977, 1.970952, 2.007041, 2.034244, 2.056423, 2.075976, 2.092587, 2.106048, 2.118534, 
                     1.923332, 2.010397, 2.06006, 2.095699, 2.121534, 2.143, 2.161297, 2.176952, 2.191556, 2.203611, 
                     2.124271, 2.20603, 2.252093, 2.283664, 2.306386, 2.327046, 2.341895, 2.356162, 2.368366, 2.380646, 
                     46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
                     1.831245, 1.922704, 1.974565, 2.010318, 2.037709, 2.060601, 2.07836, 2.094323, 2.107601, 2.119319, 
                     1.926096, 2.013529, 2.063848, 2.097026, 2.122657, 2.145204, 2.162364, 2.176803, 2.189465, 2.20082, 
                     2.125323, 2.202816, 2.248074, 2.281088, 2.305522, 2.324514, 2.342817, 2.358235, 2.36999, 2.382651, 
                     47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 
                     1.832619, 1.92402, 1.974691, 2.010889, 2.038236, 2.060752, 2.080178, 2.095511, 2.10979, 2.122067, 
                     1.927357, 2.013998, 2.064212, 2.098707, 2.125228, 2.146498, 2.1645, 2.179482, 2.192672, 2.204791, 
                     2.127652, 2.207549, 2.250843, 2.280912, 2.304763, 2.324821, 2.342402, 2.356383, 2.371136, 2.383413, 
                     48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 
                     1.835909, 1.926782, 1.978549, 2.01529, 2.04228, 2.064504, 2.081913, 2.097518, 2.111557, 2.124848, 
                     1.929896, 2.018898, 2.067448, 2.101092, 2.128047, 2.149796, 2.167222, 2.181363, 2.194296, 2.207042, 
                     2.13043, 2.20951, 2.255236, 2.284812, 2.310542, 2.329942, 2.349155, 2.365168, 2.378034, 2.389333, 
                     49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 
                     1.838915, 1.929544, 1.980889, 2.016461, 2.043453, 2.0651, 2.083133, 2.098395, 2.112205, 2.124942, 
                     1.932794, 2.020025, 2.068185, 2.101299, 2.128555, 2.150284, 2.168697, 2.182936, 2.195888, 2.208707, 
                     2.131063, 2.210605, 2.256901, 2.290031, 2.314879, 2.332995, 2.350648, 2.366389, 2.377624, 2.389405, 
                     50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
                     1.841793, 1.932885, 1.983978, 2.019288, 2.045858, 2.069004, 2.087875, 2.104538, 2.117935, 2.1305, 
                     1.936359, 2.022521, 2.072029, 2.107387, 2.133669, 2.154766, 2.171829, 2.186987, 2.200032, 2.211877, 
                     2.136214, 2.214118, 2.262521, 2.294694, 2.318319, 2.336855, 2.351645, 2.368643, 2.38084, 2.396623, 
                     51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 
                     1.844541, 1.935608, 1.986837, 2.022791, 2.05034, 2.072201, 2.08993, 2.105095, 2.119265, 2.132706, 
                     1.939135, 2.02624, 2.0752, 2.108482, 2.136233, 2.157519, 2.17545, 2.191003, 2.204304, 2.215724, 
                     2.138827, 2.218226, 2.265476, 2.296319, 2.321661, 2.341037, 2.357569, 2.372485, 2.384776, 2.394596, 
                     52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 
                     1.846872, 1.938388, 1.989322, 2.025316, 2.052089, 2.073126, 2.091614, 2.107611, 2.121495, 2.133689, 
                     1.941678, 2.028349, 2.076537, 2.110433, 2.136979, 2.15844, 2.17578, 2.191958, 2.204726, 2.215999, 
                     2.139092, 2.218625, 2.264187, 2.294732, 2.318472, 2.33794, 2.353197, 2.366418, 2.379019, 2.389765, 
                     53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 
                     1.849234, 1.940768, 1.992467, 2.027842, 2.054726, 2.076212, 2.095323, 2.111397, 2.125697, 2.139, 
                     1.944332, 2.030849, 2.079498, 2.114521, 2.142505, 2.163625, 2.179655, 2.194497, 2.208328, 2.220296, 
                     2.144822, 2.222232, 2.267111, 2.297471, 2.32236, 2.342819, 2.359392, 2.372489, 2.385176, 2.398097, 
                     54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 
                     1.851585, 1.942413, 1.992896, 2.028619, 2.055316, 2.076764, 2.094947, 2.111118, 2.125479, 2.138, 
                     1.945878, 2.031643, 2.079716, 2.114256, 2.141109, 2.162443, 2.180169, 2.195015, 2.208163, 2.220199, 
                     2.143761, 2.222481, 2.267688, 2.30123, 2.326001, 2.343542, 2.359913, 2.372077, 2.382203, 2.395066, 
                     55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 
                     1.855107, 1.944134, 1.99462, 2.030456, 2.05701, 2.078639, 2.096064, 2.111131, 2.126322, 2.137934, 
                     1.947408, 2.033314, 2.081843, 2.114876, 2.141541, 2.162976, 2.181789, 2.196412, 2.210049, 2.222355, 
                     2.143761, 2.224755, 2.272231, 2.303086, 2.326879, 2.34601, 2.362534, 2.377323, 2.39128, 2.40378, 
                     56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 
                     1.857211, 1.947672, 1.998404, 2.034135, 2.062114, 2.085016, 2.102625, 2.117452, 2.130091, 2.143014, 
                     1.951142, 2.037416, 2.087676, 2.12045, 2.145944, 2.167807, 2.184753, 2.201106, 2.214704, 2.225818, 
                     2.148334, 2.227722, 2.270704, 2.304773, 2.329404, 2.351158, 2.369563, 2.383971, 2.398677, 2.410789, 
                     57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 
                     1.859549, 1.949295, 1.998751, 2.033729, 2.060134, 2.081423, 2.100253, 2.115731, 2.129446, 2.14249, 
                     1.952793, 2.036701, 2.084645, 2.118834, 2.144989, 2.165016, 2.181952, 2.197153, 2.210343, 2.222664, 
                     2.147448, 2.224702, 2.268188, 2.30118, 2.326388, 2.343536, 2.359171, 2.373306, 2.386285, 2.394911, 
                     58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 
                     1.862539, 1.953074, 2.00296, 2.037819, 2.064722, 2.087654, 2.105948, 2.121974, 2.135298, 2.147289, 
                     1.956584, 2.041214, 2.090434, 2.124652, 2.150658, 2.172872, 2.189616, 2.20335, 2.21675, 2.229228, 
                     2.153489, 2.231175, 2.275963, 2.307439, 2.332408, 2.35033, 2.366575, 2.383191, 2.394195, 2.406571, 
                     59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 
                     1.865273, 1.955264, 2.006622, 2.041272, 2.067032, 2.088646, 2.107414, 2.122847, 2.137032, 2.148919, 
                     1.958723, 2.044431, 2.091306, 2.126044, 2.151841, 2.173642, 2.191411, 2.204921, 2.217133, 2.228708, 
                     2.154276, 2.230444, 2.275458, 2.309659, 2.333246, 2.351626, 2.370693, 2.384504, 2.396928, 2.408166, 
                     60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 
                     1.867979, 1.957653, 2.007659, 2.043297, 2.07085, 2.092827, 2.110567, 2.126213, 2.139752, 2.151429, 
                     1.960807, 2.046621, 2.095932, 2.129172, 2.155155, 2.176024, 2.193618, 2.208399, 2.222596, 2.233761, 
                     2.157699, 2.235514, 2.281672, 2.311198, 2.333175, 2.350379, 2.367316, 2.383059, 2.394662, 2.409127, 
                     61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 
                     1.869235, 1.958933, 2.01047, 2.045175, 2.072327, 2.093517, 2.110976, 2.127415, 2.140931, 2.153248, 
                     1.962354, 2.048418, 2.096415, 2.130337, 2.156598, 2.17812, 2.196138, 2.21222, 2.225772, 2.237245, 
                     2.159448, 2.239265, 2.284636, 2.318535, 2.342622, 2.358859, 2.375784, 2.3917, 2.404325, 2.416084, 
                     62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 
                     1.871407, 1.96161, 2.012437, 2.046724, 2.073882, 2.095836, 2.11364, 2.128627, 2.14271, 2.154499, 
                     1.964948, 2.049958, 2.099197, 2.131467, 2.157663, 2.178365, 2.19632, 2.210809, 2.224092, 2.235625, 
                     2.160201, 2.237283, 2.282396, 2.314492, 2.337373, 2.356579, 2.374835, 2.38762, 2.400382, 2.411127, 
                     63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
                     1.874263, 1.963775, 2.013747, 2.048624, 2.075104, 2.095699, 2.11453, 2.130248, 2.144088, 2.156083, 
                     1.967079, 2.051917, 2.098992, 2.13319, 2.159387, 2.180322, 2.197704, 2.213931, 2.228676, 2.239053, 
                     2.161945, 2.241362, 2.286118, 2.317271, 2.341941, 2.3642, 2.381027, 2.394912, 2.408944, 2.421516, 
                     64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 
                     1.876519, 1.965741, 2.016768, 2.05208, 2.07908, 2.100808, 2.118845, 2.133842, 2.148442, 2.161395, 
                     1.96919, 2.055561, 2.104311, 2.137036, 2.164335, 2.185588, 2.202906, 2.21849, 2.23226, 2.243942, 
                     2.16681, 2.246341, 2.290327, 2.319085, 2.341255, 2.361281, 2.377362, 2.391343, 2.402516, 2.413226, 
                     65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 
                     1.877374, 1.967471, 2.017682, 2.053207, 2.08072, 2.101775, 2.120207, 2.135378, 2.149027, 2.161563, 
                     1.970808, 2.056597, 2.104982, 2.138542, 2.164684, 2.185211, 2.202455, 2.218328, 2.231728, 2.243195, 
                     2.166671, 2.245852, 2.293783, 2.324957, 2.348874, 2.368883, 2.384918, 2.39835, 2.414784, 2.425323, 
                     66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 
                     1.880693, 1.969742, 2.019755, 2.053821, 2.080415, 2.102187, 2.120909, 2.136359, 2.150184, 2.16289, 
                     1.973088, 2.057293, 2.105258, 2.139789, 2.166077, 2.187152, 2.205061, 2.220511, 2.233492, 2.245185, 
                     2.168261, 2.248161, 2.294258, 2.327269, 2.351278, 2.370453, 2.385471, 2.399285, 2.412413, 2.423779, 
                     67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
                     1.882526, 1.972602, 2.023376, 2.058014, 2.08451, 2.105868, 2.124523, 2.140217, 2.15362, 2.165836, 
                     1.976017, 2.061212, 2.109191, 2.143395, 2.169086, 2.189443, 2.207407, 2.221501, 2.235338, 2.247183, 
                     2.171284, 2.24937, 2.291044, 2.324835, 2.34835, 2.365911, 2.381759, 2.396215, 2.406945, 2.416386, 
                     68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 
                     1.884305, 1.974096, 2.024016, 2.059527, 2.087177, 2.108529, 2.125795, 2.141447, 2.155796, 2.168269, 
                     1.977365, 2.062968, 2.111718, 2.145291, 2.171024, 2.19165, 2.210167, 2.22482, 2.238987, 2.251157, 
                     2.173264, 2.252883, 2.293812, 2.323561, 2.351241, 2.374481, 2.391959, 2.407005, 2.418236, 2.430527, 
                     69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 
                     1.886556, 1.976584, 2.026232, 2.061211, 2.087047, 2.109013, 2.127554, 2.142797, 2.156954, 2.169828, 
                     1.979999, 2.064617, 2.111985, 2.146193, 2.172819, 2.192495, 2.208568, 2.223682, 2.236655, 2.247801, 
                     2.17506, 2.250032, 2.294241, 2.326485, 2.35245, 2.370329, 2.387151, 2.40273, 2.413442, 2.426089, 
                     70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 
                     1.888788, 1.978671, 2.029278, 2.063181, 2.090041, 2.111673, 2.12918, 2.145537, 2.159073, 2.170716, 
                     1.981898, 2.066563, 2.114919, 2.149054, 2.173749, 2.194957, 2.212164, 2.227178, 2.240183, 2.253217, 
                     2.175971, 2.255468, 2.300134, 2.330954, 2.353698, 2.373446, 2.387852, 2.400006, 2.41447, 2.424837, 
                     71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 
                     1.890284, 1.979475, 2.029755, 2.064485, 2.091536, 2.114047, 2.131932, 2.147027, 2.159966, 2.172139, 
                     1.9827, 2.068032, 2.11712, 2.149855, 2.175222, 2.197932, 2.215656, 2.231215, 2.24404, 2.256109, 
                     2.177842, 2.258171, 2.303192, 2.335407, 2.358069, 2.378868, 2.39437, 2.410458, 2.422546, 2.433924, 
                     72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 
                     1.891516, 1.981875, 2.03224, 2.067611, 2.094304, 2.116134, 2.133732, 2.149616, 2.163833, 2.175391, 
                     1.985218, 2.071029, 2.119265, 2.153005, 2.178383, 2.198166, 2.215171, 2.229832, 2.242632, 2.254774, 
                     2.180448, 2.257535, 2.303492, 2.334028, 2.358451, 2.377373, 2.392692, 2.406159, 2.419515, 2.429027, 
                     73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 
                     1.894925, 1.983532, 2.033574, 2.06862, 2.095492, 2.116929, 2.1354, 2.150786, 2.165329, 2.176288, 
                     1.987062, 2.071632, 2.120159, 2.154134, 2.179209, 2.200801, 2.218265, 2.232445, 2.246044, 2.257656, 
                     2.181477, 2.25977, 2.305475, 2.335949, 2.359545, 2.379903, 2.397286, 2.410095, 2.423177, 2.434654, 
                     74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 
                     1.896717, 1.985632, 2.035347, 2.070272, 2.09644, 2.117765, 2.135507, 2.151089, 2.163827, 2.175507, 
                     1.988983, 2.073214, 2.120858, 2.153738, 2.178067, 2.198902, 2.216386, 2.23164, 2.244004, 2.254795, 
                     2.1806, 2.257399, 2.30123, 2.331941, 2.355559, 2.376821, 2.394572, 2.405096, 2.41715, 2.428785, 
                     75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 
                     1.897678, 1.985849, 2.035008, 2.070621, 2.097183, 2.117925, 2.135174, 2.150263, 2.163879, 2.176955, 
                     1.989046, 2.073775, 2.12087, 2.153451, 2.180057, 2.20086, 2.21837, 2.233232, 2.2463, 2.258653, 
                     2.182374, 2.260805, 2.306131, 2.334827, 2.357704, 2.378525, 2.394389, 2.40966, 2.422553, 2.434027, 
                     76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 
                     1.899438, 1.989196, 2.038874, 2.07371, 2.100825, 2.121834, 2.139512, 2.155423, 2.16907, 2.181308, 
                     1.992313, 2.077117, 2.124507, 2.158745, 2.184374, 2.205955, 2.223855, 2.238297, 2.251551, 2.263807, 
                     2.18668, 2.266206, 2.313869, 2.342915, 2.369159, 2.388852, 2.404438, 2.416762, 2.432185, 2.441844, 
                     77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 
                     1.900595, 1.988961, 2.040254, 2.07469, 2.101245, 2.1228, 2.139976, 2.155167, 2.169035, 2.181705, 
                     1.992185, 2.078073, 2.125915, 2.158274, 2.184352, 2.204249, 2.221325, 2.235427, 2.248684, 2.258917, 
                     2.186504, 2.261069, 2.306927, 2.335442, 2.359351, 2.379935, 2.396818, 2.412587, 2.424369, 2.434695, 
                     78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 
                     1.903229, 1.991749, 2.04256, 2.077584, 2.103162, 2.12478, 2.143532, 2.158309, 2.171845, 2.185086, 
                     1.995019, 2.080516, 2.128361, 2.161463, 2.18815, 2.209037, 2.22627, 2.241153, 2.255158, 2.267536, 
                     2.190368, 2.269639, 2.312014, 2.345395, 2.368624, 2.389388, 2.403122, 2.41918, 2.430958, 2.439583, 
                     79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 
                     1.904994, 1.993692, 2.043702, 2.077587, 2.104051, 2.125445, 2.145212, 2.159661, 2.172852, 2.184771, 
                     1.997004, 2.080738, 2.128741, 2.162852, 2.187623, 2.207938, 2.225288, 2.238971, 2.252219, 2.264846, 
                     2.189783, 2.266941, 2.31181, 2.342835, 2.365841, 2.382925, 2.396833, 2.411185, 2.423998, 2.432806, 
                     80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 
                     1.90616, 1.995224, 2.044402, 2.079978, 2.106453, 2.128452, 2.145984, 2.16153, 2.175021, 2.18772, 
                     1.998561, 2.083205, 2.131608, 2.164456, 2.190227, 2.211673, 2.229576, 2.244727, 2.258209, 2.268932, 
                     2.192244, 2.271052, 2.314085, 2.346309, 2.370427, 2.388449, 2.403481, 2.417351, 2.429442, 2.44041, 
                     81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 
                     1.908166, 1.996594, 2.046905, 2.08174, 2.10837, 2.12942, 2.146914, 2.16205, 2.175384, 2.187586, 
                     2.000072, 2.084852, 2.132136, 2.165108, 2.190333, 2.210583, 2.228427, 2.244215, 2.256967, 2.268291, 
                     2.192475, 2.270278, 2.311958, 2.340599, 2.365002, 2.385415, 2.401916, 2.417688, 2.433211, 2.441958, 
                     82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 
                     1.910182, 1.998171, 2.048875, 2.08408, 2.110384, 2.132498, 2.149437, 2.165897, 2.179232, 2.190715, 
                     2.001516, 2.08696, 2.135309, 2.169219, 2.193717, 2.213652, 2.23133, 2.246852, 2.258351, 2.269865, 
                     2.195554, 2.27193, 2.316911, 2.347148, 2.373651, 2.392015, 2.408391, 2.420369, 2.43263, 2.44153, 
                     83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 
                     1.911684, 1.999524, 2.049711, 2.085538, 2.111691, 2.133645, 2.150915, 2.16636, 2.180076, 2.192617, 
                     2.002801, 2.088397, 2.136429, 2.169892, 2.195782, 2.215739, 2.232867, 2.24885, 2.262715, 2.274418, 
                     2.198289, 2.276865, 2.320325, 2.350945, 2.375615, 2.393454, 2.410343, 2.426528, 2.441112, 2.450331, 
                     84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 
                     1.913332, 2.001196, 2.051048, 2.085781, 2.112122, 2.133906, 2.151251, 2.1667, 2.180862, 2.193136, 
                     2.004724, 2.089015, 2.137162, 2.169904, 2.195811, 2.216294, 2.233353, 2.248118, 2.261222, 2.271923, 
                     2.198134, 2.274091, 2.318592, 2.349652, 2.372582, 2.390486, 2.405567, 2.419068, 2.429681, 2.440815, 
                     85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 
                     1.914369, 2.002578, 2.052304, 2.087322, 2.112997, 2.134253, 2.152325, 2.168917, 2.182231, 2.193458, 
                     2.005914, 2.09039, 2.137495, 2.171892, 2.196578, 2.216744, 2.233278, 2.24831, 2.260411, 2.272541, 
                     2.19909, 2.274693, 2.321169, 2.351638, 2.376295, 2.396519, 2.411053, 2.424887, 2.436981, 2.447515, 
                     86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 
                     1.916211, 2.003808, 2.05325, 2.088297, 2.114335, 2.136165, 2.154838, 2.170056, 2.182677, 2.194887, 
                     2.00688, 2.091313, 2.13957, 2.172865, 2.197512, 2.217327, 2.233957, 2.249203, 2.260959, 2.272935, 
                     2.199896, 2.274772, 2.321809, 2.35548, 2.379467, 2.399517, 2.414507, 2.428101, 2.439963, 2.450449, 
                     87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 
                     1.91867, 2.006838, 2.056044, 2.090419, 2.117013, 2.138488, 2.156617, 2.171288, 2.184738, 2.196243, 
                     2.009899, 2.093857, 2.141633, 2.174251, 2.199087, 2.22041, 2.237723, 2.252135, 2.264756, 2.275772, 
                     2.201305, 2.278248, 2.321053, 2.351216, 2.375551, 2.393449, 2.408866, 2.422957, 2.435299, 2.445158, 
                     88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 
                     1.919014, 2.008063, 2.057049, 2.09208, 2.118585, 2.140216, 2.158318, 2.17374, 2.187064, 2.198956, 
                     2.011421, 2.095171, 2.143205, 2.176886, 2.202321, 2.22213, 2.23969, 2.25492, 2.267326, 2.279636, 
                     2.204282, 2.281692, 2.32649, 2.35599, 2.378842, 2.400178, 2.417019, 2.430987, 2.441673, 2.453921, 
                     89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 
                     1.920964, 2.009709, 2.059502, 2.093547, 2.119694, 2.141002, 2.158591, 2.174461, 2.18746, 2.199287, 
                     2.013058, 2.096788, 2.14427, 2.177574, 2.202744, 2.223122, 2.240394, 2.254903, 2.268805, 2.279776, 
                     2.205183, 2.282054, 2.325479, 2.357873, 2.382652, 2.401493, 2.417404, 2.433011, 2.445943, 2.454993, 
                     90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 
                     1.922584, 2.01102, 2.061046, 2.095466, 2.121602, 2.142225, 2.160031, 2.175605, 2.189561, 2.201926, 
                     2.01438, 2.098468, 2.145181, 2.179176, 2.205041, 2.225187, 2.243298, 2.258222, 2.271058, 2.282582, 
                     2.207519, 2.285783, 2.329447, 2.36164, 2.384344, 2.401461, 2.416299, 2.42828, 2.439433, 2.448373, 
                     91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
                     1.923038, 2.01073, 2.060025, 2.095332, 2.121736, 2.143701, 2.161235, 2.176545, 2.189438, 2.201737, 
                     2.013943, 2.09835, 2.146478, 2.179341, 2.204755, 2.225045, 2.243093, 2.258332, 2.271752, 2.282891, 
                     2.206678, 2.285023, 2.325421, 2.356557, 2.379611, 2.398656, 2.415837, 2.429727, 2.440925, 2.449561, 
                     92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 
                     1.925318, 2.013751, 2.063437, 2.098164, 2.124568, 2.145991, 2.164656, 2.179897, 2.192849, 2.204615, 
                     2.016983, 2.101158, 2.149511, 2.183295, 2.207455, 2.229076, 2.246427, 2.261931, 2.275139, 2.28586, 
                     2.209815, 2.288117, 2.330006, 2.358744, 2.382757, 2.400678, 2.414836, 2.433449, 2.446902, 2.457321, 
                     93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 
                     1.927067, 2.01522, 2.064788, 2.09835, 2.124708, 2.146076, 2.164119, 2.179815, 2.194647, 2.207782, 
                     2.018519, 2.101858, 2.149855, 2.183304, 2.210659, 2.232279, 2.249741, 2.264958, 2.27767, 2.289449, 
                     2.213258, 2.291714, 2.33315, 2.36299, 2.386856, 2.405738, 2.424355, 2.43744, 2.452291, 2.463287, 
                     94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 
                     1.928218, 2.01534, 2.065472, 2.100443, 2.126605, 2.147912, 2.166128, 2.181189, 2.195071, 2.206811, 
                     2.018829, 2.103796, 2.150719, 2.184138, 2.209704, 2.230396, 2.247848, 2.262984, 2.27532, 2.287048, 
                     2.211865, 2.289556, 2.3332, 2.362796, 2.388026, 2.40947, 2.424649, 2.436787, 2.447608, 2.45746, 
                     95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 
                     1.928658, 2.016088, 2.066005, 2.099656, 2.125082, 2.146096, 2.163309, 2.179631, 2.192897, 2.204256, 
                     2.01973, 2.10268, 2.149023, 2.182729, 2.207648, 2.227776, 2.24395, 2.257485, 2.27014, 2.282368, 
                     2.209939, 2.284616, 2.32629, 2.355212, 2.38167, 2.401218, 2.416464, 2.430433, 2.440796, 2.450854, 
                     96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 
                     1.930647, 2.01823, 2.067982, 2.102835, 2.128881, 2.14949, 2.167584, 2.182875, 2.196259, 2.207544, 
                     2.021478, 2.105879, 2.152516, 2.185919, 2.211051, 2.231539, 2.248851, 2.263125, 2.276575, 2.288504, 
                     2.213487, 2.291018, 2.331574, 2.363599, 2.385892, 2.405496, 2.42202, 2.435169, 2.445919, 2.458238, 
                     97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
                     1.93188, 2.019558, 2.069171, 2.103663, 2.129391, 2.150623, 2.168213, 2.183783, 2.196949, 2.209457, 
                     2.022993, 2.106737, 2.153478, 2.186715, 2.2122, 2.232383, 2.24883, 2.263992, 2.275884, 2.287623, 
                     2.214166, 2.290087, 2.335714, 2.368412, 2.391273, 2.408839, 2.422704, 2.43796, 2.450392, 2.459104, 
                     98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 
                     1.933654, 2.021258, 2.071204, 2.105036, 2.131584, 2.151973, 2.16986, 2.185192, 2.197988, 2.209232, 
                     2.024565, 2.107999, 2.155694, 2.188511, 2.211653, 2.233284, 2.250652, 2.266177, 2.280185, 2.291336, 
                     2.214224, 2.294182, 2.337847, 2.368687, 2.393964, 2.414289, 2.429085, 2.443362, 2.455901, 2.467792, 
                     99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
                     1.935151, 2.021787, 2.07076, 2.106073, 2.131806, 2.153162, 2.170647, 2.18538, 2.199102, 2.211934, 
                     2.024871, 2.109141, 2.155925, 2.188344, 2.215208, 2.23553, 2.252693, 2.267478, 2.279954, 2.292608, 
                     2.217615, 2.294607, 2.338065, 2.369146, 2.39323, 2.411398, 2.428084, 2.441565, 2.453995, 2.466218, 
                     100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 
                     1.936395, 2.023618, 2.073595, 2.107984, 2.1343, 2.155857, 2.174262, 2.188809, 2.202218, 2.213551, 
                     2.027228, 2.111425, 2.158606, 2.191926, 2.216465, 2.237315, 2.252546, 2.266397, 2.279976, 2.291128, 
                     2.2187, 2.293334, 2.336607, 2.367397, 2.391121, 2.411292, 2.427655, 2.441794, 2.454451, 2.464777),
                   nrow = 400, ncol = 10, byrow = T
                   )
  return(all.cv)
}
