% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQF.permu.R
\name{EQF.permu}
\alias{EQF.permu}
\title{EQF Permutation}
\usage{
EQF.permu(
  LOD.QTLdetect.result,
  ptime = 1000,
  alpha = 0.05,
  Q = TRUE,
  console = TRUE
)
}
\arguments{
\item{LOD.QTLdetect.result}{list. The data list of the output from
LOD.QTLdetect.}

\item{ptime}{integer. The permutation time.}

\item{alpha}{numeric. The type 1 error rate of detecting the hotspot.}

\item{Q}{logical. If being TURE, the function will further be carrying
out the population of Q method as the control group and shown as B in
the output.}

\item{console}{logical. To decide whether the process of algorithm will
be shown in the R console or not.}
}
\value{
\item{EQF.matrix}{The matrix denote the EQF value of each bin.}
\item{bin}{The bin infromation matrix used in this analyze.}
\item{LOD.threshole}{The LOD threshold used in this analyze.}
\item{cluster.number}{The number of QTLs in each cluster group.}
\item{cluster.id}{The serial number of traits in each cluster group.}
\item{cluster.matrix}{The new EQF matrix from the clustering process.}
\item{permu.matrix.cluster}{the permutation result of the clustering
method which has been sorted by order.}
\item{permu.matrix.Q}{The permutation result of the Q method which has
been sorted by order.}
\item{EQF.threshold}{The EQF threshold calculated from the permutation
process.}
}
\description{
The EQF matrix cluster permutation process for QTL hotspot detection.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))

# run and result
result <- EQF.permu(LOD.QTLdetect.result, ptime = 50)
result$cluster.number
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056.
}
\seealso{
\code{\link[QTLEMM]{LOD.QTLdetect}}
\code{\link[QTLEMM]{EQF.plot}}
}
