% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.make.R
\name{Q.make}
\alias{Q.make}
\title{Generate Q Matrix}
\usage{
Q.make(
  QTL,
  marker,
  geno = NULL,
  interval = FALSE,
  type = "RI",
  ng = 2,
  cM = TRUE
)
}
\arguments{
\item{QTL}{matrix. A q*2 matrix contains the QTL information, where the
row dimension 'q' represents the number of QTLs in the chromosomes. The
first column labels the chromosomes where the QTLs are located, and the
second column labels the positions of QTLs (in morgan (M) or centimorgan
(cM)).}

\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension 'k' represents the number of markers in the
chromosomes. The first column labels the chromosomes where the markers
are located, and the second column labels the positions of markers (in
morgan (M) or centimorgan (cM)). It's important to note that chromosomes
and positions must be sorted in order.}

\item{geno}{matrix. A n*k matrix contains the genotypes of k markers
for n individuals. The marker genotypes of P1 homozygote (MM),
heterozygote (Mm), and P2 homozygote (mm) are coded as 2, 1, and 0,
respectively, with NA indicating missing values.}

\item{interval}{logical. When set to interval=TRUE, if a QTL shares the
same position as a marker, the marker will be skipped and not considered
as a flanking marker.}

\item{type}{character. The population type of the dataset. Includes
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI"). The default value is "RI".}

\item{ng}{integer. The generation number of the population type. For
instance, in a BC1 population where type="BC", ng=1; in an AI F3
population where type="AI", ng=3.}

\item{cM}{logical. Specify the unit of marker position. If cM=TRUE, it
denotes centimorgan; if cM=FALSE, it denotes morgan.}
}
\value{
The output contains k conditional probability matrices for the k
flanking marker pairs (the k Q-matrices) and a conditional
probability matrix of each QTL for all individuals (the cp-matrix)
provided the genotype data of the testing population is input..
}
\description{
Generate the conditional probability matrix using the information of QTL
and marker, along with the genotype data.
}
\note{
If geno=NULL, the function can still be executed, and the output will
contain k Q-matrices but no cp-matrix.
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
result <- Q.make(QTL, marker, geno)
head(result$cp.matrix)
}
\references{
KAO, C.-H. and Z.-B. ZENG 1997 General formulas for obtaining the maximum
likelihood estimates and the asymptotic variance-covariance matrix in QTL
mapping when using the EM algorithm. Biometrics 53, 653-665. <doi: 10.2307/2533965.>

KAO, C.-H., Z.-B. ZENG and R. D. TEASDALE 1999 Multiple interval mapping
for Quantitative Trait Loci. Genetics 152: 1203-1216. <doi: 10.1093/genetics/152.3.1203>
}
