% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optQp.R
\name{evalQp}
\alias{evalQp}
\title{Optimal Quantile Predictor}
\usage{
evalQp(formula, data, seeds, pct_train = 0.8, minbucket.p = 0.5)
}
\arguments{
\item{formula}{\link[stats]{formula}, currently only supports one \link[survival]{Surv} endpoint
and one predictor of the markers.
See details of parameter \code{data}.}

\item{data}{\link[base]{data.frame}, with at least
\itemize{
\item one \link[survival]{Surv} column as the survival outcome
\item one \link[base]{matrix} column as the predictor of quantile sequence
}}

\item{seeds}{\link[base]{integer} vector of random seeds for generating repeated samples, see \link[base]{set.seed}}

\item{pct_train}{\link[base]{numeric} scalar, proportion of the training set, default \code{.8}}

\item{minbucket.p}{(for \link[rpart]{rpart} function) the minimum number of observations in any terminal \strong{leaf} node. If only
one of \code{minbucket} or \code{minsplit} is specified, the code either sets \code{minsplit} to
\code{minbucket*3} or \code{minbucket} to \code{minsplit/3}, as appropriate.}
}
\value{
\link{evalQp} returns a \link{evalQp} object, which is a \link[base]{list} with two \link[base]{matrix} elements
\code{thresholds} and \code{coefs}.

\itemize{
\item {\code{thresholds} is ...}
\item {\code{coefs} is ...}
}
}
\description{
From the sequence of sample quantiles, selects the optimal quantile that has highest predictive value for a given survival outcome
}
\examples{
# see ?optQp


}
