% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandl.R
\name{Quandl.dataset.get}
\alias{Quandl.dataset.get}
\title{Retrieves Data from the Quandl Dataset endpoint}
\usage{
Quandl.dataset.get(code, params)
}
\arguments{
\item{code}{Dataset code on Quandl specified as a string.}

\item{params}{A list of parameters to be passed to the Quandl API. Please see \url{https://docs.quandl.com/docs/in-depth-usage#get-time-series-metadata} for a full list of parameters.}
}
\value{
Returns a data.frame of the requested data
}
\description{
Retrieves Data from the Quandl Dataset endpoint
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/profile}
}
\examples{
\dontrun{
quandldata = Quandl.dataset.get("NSE/OIL", list(rows=5))
plot(quandldata[,1])
}
}
\seealso{
\code{\link{Quandl.api_key}}, \code{\link{Quandl}}
}
