% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{coupon.dates}
\alias{coupon.dates}
\title{Coupon date payments}
\usage{
coupon.dates(
  maturity,
  analysis.date = Sys.Date(),
  asset.type = "TES",
  freq = NULL,
  convention = "F",
  loc = "BOG",
  trade.date = NULL,
  coupon.schedule = "SF"
)
}
\arguments{
\item{maturity}{Last day of the contract: YYYY-MM-DD.
Alternatively, it can be a numeric value that represents the duration of the contract in years.}

\item{analysis.date}{Date in which the asset is valued. By default, the
current date.}

\item{asset.type}{String that determines the asset type to value. See also
'Details'.}

\item{freq}{Frequency of payments of a given asset in a year. For LIBOR and
IBR the default frequency is four (quarterly payments). TES has a default
frequency of one (annual payments).}

\item{convention}{String that establishes if the effective dates are
calculated using Following, Modified Following, Backward or Backward Following.
See also 'Details'.}

\item{loc}{String related to the location of the asset. It is used to
calculate the effective dates, taking into account the business days
of the given location. See also 'Details'.}

\item{trade.date}{The date on which the transaction occurs. It is used to calculate
maturity as a date, when given in years. Also required for non-trivial cases such as
bonds with long first coupon.}

\item{coupon.schedule}{String that establishes if a bond first coupon period is a long
first coupon or a short first coupon. On the contrary, establishes if last coupon period
is long last coupon or a short last coupon. See also 'Details'.}
}
\value{
Upcoming coupon dates and dates of payment according to business day conventions.
}
\description{
Function to calculate the upcoming coupon payment dates of a given asset,
based on its payment frequency. The list of payment dates encompass
the time period between the analysis date and the maturity of the asset.
}
\details{
\code{asset.type} makes reference to the following type of assets:
\itemize{
   \item "TES" for Colombian Treasury Bonds (default).
   \item "FixedIncome" for assets that are indexed to a fixed income with
   different frequency of payments.
   \item "IBR" for bonds and assets indexed to 3M IBR rate.
   \item "IBRSwaps" for swaps indexed to IBR rate.
   \item "LIBOR" for bonds and assets indexed to 3M LIBOR.
   \item "UVRSwaps" for cross-currency swaps indexed to UVR-IBR rate.
   \item "LIBORSwaps" for Interest Rate Swaps (IRS) indexed to 3M LIBOR.
     }

\code{loc} makes reference to the following locations:
\itemize{
   \item "BOG" for colombian issued assets and national business days
   (default).
   \item "LDN" for business days of London.
   \item "NY" for business days of New York
   \item "NYLDN" for the intersection of business days in New York and
   London.
   \item "BOGNY" for the intersection of business days in Bogota and
   New York.
     }

\code{convention} makes reference to the following type of business day conventions:
\itemize{
   \item "F" for Following business day convention.
   \item "MF" for Modified Following business day convention.
   \item "B" for Backward business day convention.
   \item "MB" for Modified Backward business day convention.
     }

\code{coupon.schedule} makes reference to the following type of coupon payment schedule
of a bond:
\itemize{
   \item "LF" for Long First coupon payment.
   \item "LL" for Long Last coupon payment.
   \item "SF" for Short First coupon payment.
   \item "SL" for Short Last coupon payment.
     }
}
\note{
If only maturity is given, function assumes that the coupon payments have
already started. If \code{maturity} and \code{trade.date} are included,
coupon dates are calculated from \code{trade.date} to \code{maturity}.
If by doing so, \code{trade.date} doesn't converge to \code{maturity}, month remainder
is adjusted according to \code{coupon.schedule}.
For LIBOR assets, function adds 2 business days to \code{trade.date}.
}
\examples{
coupon.dates("2028-04-03")
coupon.dates(maturity = 2, analysis.date = "2021-10-01")
coupon.dates(maturity = "2029-10-01", asset.type = "FixedIncome", freq = 2, convention = "MB")
coupon.dates(maturity = "2028-02-29", analysis.date = "2022-07-29", trade.date = "2022-07-29",
             asset.type = "TES", coupon.schedule = "SF")
coupon.dates(maturity = "2025-11-30", analysis.date = "2022-03-01", trade.date = "2021-05-31",
             asset.type = "IBR", loc = "NY", convention = "F")
}
