% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fmx.R
\name{plot_fmx}
\alias{plot_fmx}
\alias{plot.fmx}
\alias{autoplot.fmx}
\alias{plot.fmx_QLMDe}
\alias{autoplot.fmx_QLMDe}
\title{Plot \code{'fmx'} and \code{'fmx_QLMDe'} object using vanilla R and/or \pkg{ggplot2}}
\usage{
\method{plot}{fmx}(
  x,
  xlim = qfmx(p = c(0.01, 0.99), dist = dist),
  ylab = paste("Finite Mixture of", dist@distname),
  n = 501L,
  ...
)

\method{autoplot}{fmx}(
  object,
  type = c("pdf", "cdf"),
  xlim = qfmx(p = c(0.005, 0.995), dist = object),
  v = double(),
  layer = FALSE,
  lty = 1L,
  curve.col = 1L,
  ylab = paste(object@distname, "mixture"),
  n = 501L,
  ...
)

\method{plot}{fmx_QLMDe}(
  x,
  xlab = x@data.name,
  main = NULL,
  hist.col = "grey90",
  breaks = "Sturges",
  border = "white",
  curve.col = "black",
  lty = 1L,
  n = 501L,
  ...
)

\method{autoplot}{fmx_QLMDe}(
  object,
  type = c("hist", "ecdf"),
  plot_ef = TRUE,
  plot_init = FALSE,
  plot_p = TRUE,
  plot_origK = TRUE,
  curve.col = 1,
  xlim = c(min(object@data), max(object@data)),
  xlab = object@data.name,
  main = NULL,
  caption = if (plot_p) paste(length(object@p), "percentiles matched"),
  layer = FALSE,
  n = 501L,
  ...
)
}
\arguments{
\item{x, object}{\code{'fmx'} or \code{'fmx_QLMDe'} object, to match the S3 definition of \code{\link[base]{plot}} and \code{\link[ggplot2]{autoplot}}}

\item{xlim}{see \code{\link[graphics]{curve}} and \code{\link[ggplot2]{stat_function}}.}

\item{n}{see \code{\link[graphics]{curve}} and/or \code{\link[ggplot2]{stat_function}}.}

\item{...}{potential parameters of \code{\link[graphics]{curve}} in \code{\link{plot.fmx}}, or 
potential parameters of \code{\link[graphics]{hist.default}} in \code{\link{plot.fmx_QLMDe}}.}

\item{type}{\code{'character'} value. For an input of \code{'fmx'} object, this argument specifies 
whether to generate a plot of probability density function (\code{'pdf'}, default), 
or to generate a plot of cumulative distribution function (\code{'cdf'}).
For an input of \code{'fmx_QLMDe'} object, this argument specifies 
whether to generate a plot of histogram (\code{'hist'}, default) together with the estimated probability density function,
or to generate a plot of empirical cumulative distribution function (\code{'ecdf'}) together with the estimated cumulative distribution function.}

\item{v}{\code{'double'} vector, the vertical lines to be added to the plot of an \code{'fmx'} object, default \code{double()} indicating no vertical lines.}

\item{layer}{\code{'logical'} value, whether to produce the figure as a \pkg{ggplot2} \code{\link[ggplot2]{layer}} (default \code{FALSE}).}

\item{lty}{line type of the finite mixture density curve, see \code{\link[graphics]{plot.xy}}, 
or parameter \code{linetype} of \code{\link[ggplot2]{stat_function}}.}

\item{curve.col}{color of the finite mixture density curve, the parameter \code{col} of \code{\link[graphics]{plot.xy}}, or
the parameter \code{colour} of \code{\link[ggplot2]{stat_function}}.}

\item{xlab, ylab, main, caption, border, breaks}{see \code{\link[graphics]{hist.default}} and/or \code{\link[ggplot2]{labs}}.}

\item{hist.col}{color of the body of histogram, see the parameter \code{col} of \code{\link[graphics]{hist.default}}.}

\item{plot_ef, plot_init, plot_p, plot_origK}{\code{'logical'} value, whether 
to plot the empirical probability density function or the empirical probability density function (default \code{TRUE}),
to plot the initial estimates (default \code{FALSE}),
to plot the percentages at which the sample and theoretical quantiles are matched (default \code{TRUE}),
or to plot the \code{'fmx_QLMDe'} at the user-specified number of components \eqn{K} 
(if backward-forward selection on number of component is performed; default \code{TRUE}).}
}
\value{
\code{\link{plot.fmx}} and \code{\link{plot.fmx_QLMDe}} do not have return value; only \code{\link[graphics]{curve}} is called for plotting.

\code{\link{autoplot.fmx}} and \code{\link{autoplot.fmx_QLMDe}} return \code{'ggplot'} object, created by \code{\link[ggplot2]{ggplot}}.
}
\description{
Plot \code{'fmx'} and \code{'fmx_QLMDe'} object using vanilla R and/or \pkg{ggplot2}.
}
