% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop1.fmx.R
\name{drop1_fmx}
\alias{drop1_fmx}
\alias{drop1.fmx}
\alias{add1.fmx}
\title{Drop or Add One Parameter from \linkS4class{fmx} Object}
\usage{
\method{drop1}{fmx}(object, ...)

\method{add1}{fmx}(object, ...)
}
\arguments{
\item{object}{\linkS4class{fmx} object}

\item{...}{additional parameters, currently not in use.}
}
\value{
\link{drop1.fmx} and \link{add1.fmx} return a \link[base]{list} of \linkS4class{fmx} objects,
in the reverse order of model selection.
}
\description{
Fit \linkS4class{fmx} models with a single parameters being added or dropped.
}
\details{
..
}
\note{
Note that \link{drop1.fmx} and \link{add1.fmx} do \strong{not} return an \link[stats]{anova} table, like other
\code{stats:::drop.*} or \code{stats:::add1.*} functions do.
}
\examples{

\donttest{ 

# donttest to save time

(d2 = fmx('GH', A = c(1,6), B = 1.2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(3123); hist(x2 <- rfmx(n = 1e3L, dist = d2))
system.time(m0 <- QLMDe(x2, distname = 'GH', K = 2L, constraint = c('g1', 'g2', 'h1', 'h2')))
system.time(m1 <- QLMDe(x2, distname = 'GH', K = 2L, constraint = c('g1', 'h2')))
system.time(m2 <- QLMDe(x2, distname = 'GH', K = 2L)) # ~2 secs

d1 = drop1(m1)
d1 # NULL
d2 = drop1(m2)
vapply(d2, FUN = constraint_TeX, FUN.VALUE = '')

a0 = add1(m0)
vapply(a0, FUN = constraint_TeX, FUN.VALUE = '')
a1 = add1(m1)
vapply(a1, FUN = constraint_TeX, FUN.VALUE = '')

}

}
\seealso{
\link[stats]{step} \link[stats]{drop1} \link[stats]{add1}
}
