% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPoints.R
\name{SymmetricDifferenceLineEnds}
\alias{SymmetricDifferenceLineEnds}
\alias{SymmetricDifferenceLines}
\title{Plot contours of equal symmetric difference on a ternary plot}
\usage{
SymmetricDifferenceLineEnds(nsd)

SymmetricDifferenceLines(nsd, ...)
}
\arguments{
\item{nsd}{Vector specifying normalized symmetric differences to plot.}

\item{\dots}{Further parameters to pass to
\code{\link[Ternary:AddToTernary]{TernaryLines}()}.}
}
\value{
Returns a matrix of dim \verb{(length(nsd), 6)}, with columns named
\code{r2a}, \code{da}, \code{sa}, \code{r2b}, \code{db} and \code{sb}.
Lines from \code{a} to \code{b} in each row connect points of equal symmetric difference.
}
\description{
Assumes that tree 1 is perfectly resolved, but that the resolution
of tree 2 can vary.
}
\section{Functions}{
\itemize{
\item \code{SymmetricDifferenceLines}: Plot the lines onto the active ternary plot.
}}

\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
