% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tqDist.r
\name{TQDist}
\alias{TQDist}
\alias{TQAE}
\title{Wrapper for tqDist}
\usage{
TQDist(trees)

TQAE(trees)
}
\arguments{
\item{trees}{List of phylogenetic trees, of class \code{list} or
\code{\link[ape:read.tree]{multiPhylo}}.}
}
\value{
\code{TQDist()} returns the quartet distance between each pair of trees.

\code{TQAE()} returns the number of resolved quartets in agreement between
each pair of trees ('A' in Brodal \emph{et al}. 2013) and the number of quartets
that are unresolved in both trees ('E' in Brodal \emph{et al}. 2013).
}
\description{
Convenience function that takes a list of trees, writes them to the text
file expected by the C implementation of tqDist (Sand \emph{et al.} 2014).
tqDist is then called, and the temporary file is deleted when analysis is
complete.
}
\details{
Quartets can be resolved in one of five ways, which Brodal \emph{et al}. (2013)
and Holt \emph{et al}. (2014) distinguish using the letters A--E, and
Estabrook \emph{et al.} (1985) refers to as:
\itemize{
\item A: \emph{s} = resolved the \strong{s}ame in both trees;
\item B: \emph{d} = resolved \strong{d}ifferently in both trees;
\item C: \emph{r1} = \strong{r}esolved only in tree \strong{1};
\item D: \emph{r2} = \strong{r}esolved only in tree \strong{2} (the comparison tree);
\item E: \emph{u} = \strong{u}nresolved in both trees.
}
}
\references{
\itemize{
\item \insertRef{Brodal2013}{Quartet}
\item \insertRef{Estabrook1985}{Quartet}
\item \insertRef{Holt2014}{Quartet}
\item \insertRef{Sand2014}{Quartet}
}
}
\seealso{
\code{\link[=CompareQuartets]{CompareQuartets()}}, \code{\link[=QuartetStatus]{QuartetStatus()}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
