% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tqdist_QuartetDistance}
\alias{tqdist_QuartetDistance}
\alias{tqdist_QuartetAgreement}
\alias{tqdist_QuartetAgreementEdge}
\alias{tqdist_QuartetAgreementChar}
\alias{tqdist_PairsQuartetDistance}
\alias{tqdist_OneToManyQuartetAgreement}
\alias{tqdist_OneToManyQuartetAgreementChar}
\alias{tqdist_OneToManyQuartetAgreementEdge}
\alias{tqdist_AllPairsQuartetDistance}
\alias{tqdist_AllPairsQuartetDistanceChar}
\alias{tqdist_AllPairsQuartetDistanceEdge}
\alias{tqdist_AllPairsQuartetAgreement}
\alias{tqdist_AllPairsQuartetAgreementChar}
\alias{tqdist_AllPairsQuartetAgreementEdge}
\alias{tqdist_TripletDistance}
\alias{tqdist_PairsTripletDistance}
\alias{tqdist_AllPairsTripletDistance}
\title{Direct entry points to 'tqDist' functions}
\usage{
tqdist_QuartetDistance(file1, file2)

tqdist_QuartetAgreement(file1, file2)

tqdist_QuartetAgreementEdge(edge1, edge2)

tqdist_QuartetAgreementChar(string1, string2)

tqdist_PairsQuartetDistance(file1, file2)

tqdist_OneToManyQuartetAgreement(file1, fileMany)

tqdist_OneToManyQuartetAgreementChar(tree, trees)

tqdist_OneToManyQuartetAgreementEdge(edge, edges)

tqdist_AllPairsQuartetDistance(file)

tqdist_AllPairsQuartetDistanceChar(string)

tqdist_AllPairsQuartetDistanceEdge(edges)

tqdist_AllPairsQuartetAgreement(file)

tqdist_AllPairsQuartetAgreementChar(string)

tqdist_AllPairsQuartetAgreementEdge(edges)

tqdist_TripletDistance(file1, file2)

tqdist_PairsTripletDistance(file1, file2)

tqdist_AllPairsTripletDistance(file)
}
\arguments{
\item{file, file1, file2}{Paths to files containing a tree or trees in Newick format.}
}
\value{
The distance between the requested trees.
}
\description{
Functions to calculate triplet and quartet distances between pairs of trees.
Input is not checked for sanity.
}
\details{
Functions are called from R with user-friendly functions such as
\code{\link{AllPairsQuartetDistance}}.
}
\section{Functions}{
\itemize{
\item \code{tqdist_QuartetAgreement}: Agreement of each quartet

\item \code{tqdist_QuartetAgreementEdge}: Agreement of each quartet

\item \code{tqdist_QuartetAgreementChar}: Agreement of each quartet

\item \code{tqdist_PairsQuartetDistance}: Distance between pairs

\item \code{tqdist_OneToManyQuartetAgreement}: Distance between pairs

\item \code{tqdist_OneToManyQuartetAgreementChar}: Distance between pairs

\item \code{tqdist_OneToManyQuartetAgreementEdge}: Distance between pairs

\item \code{tqdist_AllPairsQuartetDistance}: Distance between all pairs

\item \code{tqdist_AllPairsQuartetDistanceChar}: Distance between all pairs

\item \code{tqdist_AllPairsQuartetDistanceEdge}: Distance between all pairs

\item \code{tqdist_AllPairsQuartetAgreement}: Agreement between all pairs of trees

\item \code{tqdist_AllPairsQuartetAgreementChar}: Agreement between all pairs of trees

\item \code{tqdist_AllPairsQuartetAgreementEdge}: Agreement between all pairs of trees

\item \code{tqdist_TripletDistance}: Triplet distance between two trees

\item \code{tqdist_PairsTripletDistance}: Triplet distance between pairs

\item \code{tqdist_AllPairsTripletDistance}: Triplet distance between all pairs
}}

\references{
\insertRef{Sand2014}{Quartet}
}
\author{
Martin R. Smith, after Andreas Sand
}
\keyword{internal}
