% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parsers.R
\name{parse_victorx3}
\alias{parse_victorx3}
\title{Extract relevant data from a raw data export file generated from the software of Perkin Elmer's "Victor X3" plate readers.}
\usage{
parse_victorx3(input)
}
\arguments{
\item{input}{A dataframe created by reading a table file with \code{\link{read_file}}}
}
\value{
a list of length two containing growth and/or fluorescence dataframes in the first and second element, respectively. The first column in these dataframes represents a time vector.
}
\description{
Extract relevant data from a raw data export file generated from the software of Perkin Elmer's "Victor X3" plate readers.
}
\examples{
if(interactive()){
input <- read_file(filename = system.file("victorx3_output.txt", package = "QurvE") )
parsed <- parse_victorx3(input)
}
}
