% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{extreme_docs}
\alias{extreme_docs}
\title{extreme_docs}
\usage{
extreme_docs(corpus, ca, axis, ndocs = 10, nterms = 25)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{ca}{A \code{\link[FactoMineR:CA]{CA}} object.}

\item{axis}{The CA axis to consider.}

\item{ndocs}{The number of (most contributive) documents to print.}

\item{nterms}{The number of terms to highlight in documents.}
}
\value{
\code{Corpus} object (invisibly).
}
\description{
Print documents which have the most extreme coordinations on an axis of correspondence analysis.
}
\details{
Occurrences of the \code{nterms} most extreme terms are highlighted.
If stemming or other transformations have been applied to original words
using \code{\link{combine_terms}}, all original words which have been transformed
to the specified terms are highlighted.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
ca <- corpus_ca(corpus, dtm)
contributive_docs(corpus, ca, 1)

# Also works when terms have been combined
dict <- dictionary(dtm)
dtm2 <- combine_terms(dtm, dict)
ca2 <- corpus_ca(corpus, dtm2)
extreme_docs(corpus, ca2, 1)

}
