\name{sa.time}
\alias{sa.time}
\title{Sensitivity analysis of basic reproduction ratio to begin/end dates}
\description{Sensitivity analysis of reproduction ratio using supported estimation methods.}
\usage{sa.time(incid, GT, begin = NULL, 
    end = NULL, est.method, 
    t = NULL, date.first.obs = NULL, 
    time.step = 1, res = NULL, 
    ...)}
\arguments{
  \item{incid}{incident cases}
  \item{GT}{generation time distribution}
  \item{begin}{Vector of begins date of the estimation of epidemic}
  \item{end}{Vector of \code{end} dates of estimation of the epidemic}
  \item{est.method}{Estimation method used for sensitivity analysis}
  \item{t}{Dates vector to be passed to estimation function}
  \item{date.first.obs}{Optional date of first observation, if \code{t} not specified}
  \item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation}
  \item{res}{If specified, will extract most of data from a R0.R-class result already generated by est.R0 and run sensitivity analysis on it.}
  \item{\dots}{parameters passed to inner functions}
}
\details{By varying different pairs of \code{begin} and \code{end} dates,different estimates of reproduction ratio can be analyzed.

'begin' and 'end' vector must have the same length for the sensitivity analysis to run.
They can be provided either as "dates" or "numeric" values, depending on the other parameters (see \link{check.incid}).
If some begin/end dates overlap, they are ignored, and corresponding uncomputed data are set to NA.
Also, note that unreliable Rsquared values are achieved for very small time period (\code{begin} ~ \code{end}).
These values are not representative of the epidemic outbreak behaviour.}
\value{A list with components as a data frame:
\item{df}{data.frame object with all results from sensitivity analysis.}
\item{df.clean}{the same object, with NA rows removed. Used only for easy export of results.}
\item{mat.sen}{Matrix with values of R0 given \code{begin} (rows) and \code{end} (columns) dates.}
\item{begin}{A range of \code{begin} dates in epidemic.}
\item{end}{A range of \code{end} dates in epidemic.}}

\author{Pierre-Yves Boelle, Thomas Obadia}





