% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predLines.r
\name{predLines}
\alias{predLines}
\title{Draws predicted lines using a fitted model object}
\usage{
predLines(object, indata = NULL, xname, lev = 2, selected = NULL,
  probs = c(0.025, 0.975), legend = TRUE, legend.space = "top",
  legend.ncol = 4, ...)
}
\arguments{
\item{object}{Either an \code{\link{mlwinfitIGLS-class}} or \code{\link{mlwinfitMCMC-class}}
object.}

\item{indata}{A data.frame object containing the data. If not specified, data is extracted from
the \code{object}.}

\item{xname}{The name of the variable to be plotted.}

\item{lev}{A digit indicating the level (of the multilevel model) at which
to plot.}

\item{selected}{A vector specifying groups to selectively plot at the level
specified in \code{lev}. If \code{selected = NULL}, then all groups at that
level are included.}

\item{probs}{A numeric vector of probabilities with values in \code{[0, 1]}
used to calculate the lower and upper quantiles from which the error bars
are plotted. Currently, this is only available for an \code{\link{mlwinfitMCMC-class}} object.}

\item{legend}{A logical value indicating whether a legend is to be added.}

\item{legend.space}{A character string specifies one of the four sides,
which can be one of \code{'top'}, \code{'bottom'}, \code{'left'} and \code{'right'}.  Default,
\code{legend.space = 'top'}.}

\item{legend.ncol}{An integer specifies a number of columns, possibly
divided into blocks, each containing some rows. Default,
\code{legend.ncol = 2}.}

\item{...}{Other arguments to be pased to \code{\link[lattice]{xyplot}}.}
}
\description{
This function draws predicted lines against an explanatory variable for
selected groups at a higher (>=2) level. Note that it uses a lot of contiguous memory, and so
we recommend running via 64-bit version R to mititage against any potential problems.
}
\examples{

\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Example: tutorial
data(tutorial, package = "R2MLwiN")
(mymodel <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school) + (1 | student),
                     estoptions = list(EstM = 1, resi.store.levs = 2), data = tutorial))

predLines(mymodel, xname = "standlrt", lev = 2, selected = c(30, 44, 53, 59),
          probs = c(0.025, 0.975))
}

}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{predCurves}}
}

