% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_portfolio_template.R
\name{create_portfolio_template}
\alias{create_portfolio_template}
\title{Create Portfolio Template}
\usage{
create_portfolio_template()
}
\value{
A nested \code{tibble} of class 'Portfolio' with columns:
\itemize{
\item \code{name}
\item \code{expected_return}
\item \code{standard_deviation}
\item \code{accounts}
\itemize{
\item \code{taxable}
\item \code{taxadvantaged}
}
\item \code{weights}
\itemize{
\item \code{human_capital}
\item \code{liabilities}
}
\item \code{correlations}
\item \code{pretax}
\itemize{
\item \code{turnover}
\item \code{income_qualified}
\item \code{capital_gains_long_term}
\item \code{income}
\item \code{capital_gains}
\item \code{cost_basis}
}
}
}
\description{
Creates a template for default portfolio with
two asset classes:
\itemize{
\item \code{GlobalStocksIndexFund}
\item \code{InflationProtectedBonds}
}
}
\details{
The template is used as a starting point for creating a portfolio.
The asset classes have some reasonable default values of
expected returns and standard deviations of returns.
The template assumes no correlations between asset classes in
the \code{correlations} matrix.
Please check and update the template assumptions if necessary.

The nested \code{pretax} columns contain default values for
parameters needed for calculating effective tax rates.
The template assumes only capital gains tax is paid.
Please customise this template to your individual situation.

The \code{accounts} nested columns have zero values for all assets
by default in both taxable and tax-advantaged accounts.
The template assumes that there is currently no financial
wealth allocated to those accounts.
Please customise this template to your individual situation.

The \code{weights} nested columns define weights of assets in
portfolios representative of the household human capital and liabilities.
The template assumes equal weights for all assets for both portfolios.
Please customise this template to your individual situation.
}
\examples{
  portfolio <- create_portfolio_template()
  portfolio$accounts$taxable <- c(10000, 30000)
  portfolio
}
\seealso{
Possible sources of market assumptions:
\itemize{
\item \url{https://elmwealth.com/capital-market-assumptions/}
\item \url{https://www.obligacjeskarbowe.pl/oferta-obligacji/obligacje-10-letnie-edo/}
\item \url{https://www.msci.com/indexes/index/664204}
\item (PDF) https://research.ftserussell.com/Analytics/FactSheets/Home/DownloadSingleIssue?issueName=AWORLDS&isManual=False
}
}
