% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal_counterfactual.R
\name{ParallelWorld}
\alias{ParallelWorld}
\title{R6 Class for parallel world models}
\description{
R6 Class for parallel world models

R6 Class for parallel world models
}
\details{
Inherits R6 class SCM.
}
\examples{

## ------------------------------------------------
## Method `ParallelWorld$new`
## ------------------------------------------------

backdoor_parallel <- ParallelWorld$new(
                        backdoor,
                        dolist=list(
                            list(target = "x", 
                                 ifunction = 0),
                            list(target = list("z","x"), 
                                 ifunction = list(1,0))
                        )
)
backdoor_parallel 
plot(backdoor_parallel)
}
\section{Super class}{
\code{\link[R6causal:SCM]{R6causal::SCM}} -> \code{ParallelWorld}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{num_worlds}}{Number of parallel worlds.}

\item{\code{worldnames}}{Names of parallel worlds.}

\item{\code{worldsuffix}}{Suffix used for parallel world variables.}

\item{\code{originalscm}}{SCM from which the parallel worlds are derived.}

\item{\code{dolist}}{List containing the interventions for each world.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParallelWorld-new}{\code{ParallelWorld$new()}}
\item \href{#method-ParallelWorld-clone}{\code{ParallelWorld$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="add_variable"><a href='../../R6causal/html/SCM.html#method-SCM-add_variable'><code>R6causal::SCM$add_variable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="an"><a href='../../R6causal/html/SCM.html#method-SCM-an'><code>R6causal::SCM$an()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="causal.effect"><a href='../../R6causal/html/SCM.html#method-SCM-causal.effect'><code>R6causal::SCM$causal.effect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="ch"><a href='../../R6causal/html/SCM.html#method-SCM-ch'><code>R6causal::SCM$ch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="de"><a href='../../R6causal/html/SCM.html#method-SCM-de'><code>R6causal::SCM$de()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="dosearch"><a href='../../R6causal/html/SCM.html#method-SCM-dosearch'><code>R6causal::SCM$dosearch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="intervene"><a href='../../R6causal/html/SCM.html#method-SCM-intervene'><code>R6causal::SCM$intervene()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="pa"><a href='../../R6causal/html/SCM.html#method-SCM-pa'><code>R6causal::SCM$pa()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="plot"><a href='../../R6causal/html/SCM.html#method-SCM-plot'><code>R6causal::SCM$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="print"><a href='../../R6causal/html/SCM.html#method-SCM-print'><code>R6causal::SCM$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="remove_variable"><a href='../../R6causal/html/SCM.html#method-SCM-remove_variable'><code>R6causal::SCM$remove_variable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="simulate"><a href='../../R6causal/html/SCM.html#method-SCM-simulate'><code>R6causal::SCM$simulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="tikz"><a href='../../R6causal/html/SCM.html#method-SCM-tikz'><code>R6causal::SCM$tikz()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParallelWorld-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParallelWorld-new}{}}}
\subsection{Method \code{new()}}{
Create a new ParallelWorld object from an SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParallelWorld$new(scm, dolist, worldnames = NULL, worldsuffix = "_")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scm}}{An SCM object.}

\item{\code{dolist}}{A list containing the interventions for each world. Each element 
of the list has the fields:
\itemize{
\item target: a vector of variable names that specify the target
variable(s) of the counterfactual intervention.
\item ifunction: a list of functions for the counterfactual intervention.
}}

\item{\code{worldnames}}{A character vector giving the names of the parallel worlds.}

\item{\code{worldsuffix}}{A text giving the suffix used for parallel world variables 
before the world number. Defaults to "_" and the worlds have then suffixes 
"_1", "_2", "_3", ...}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `ParallelWorld` object that also belongs to class `SCM`.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor_parallel <- ParallelWorld$new(
                        backdoor,
                        dolist=list(
                            list(target = "x", 
                                 ifunction = 0),
                            list(target = list("z","x"), 
                                 ifunction = list(1,0))
                        )
)
backdoor_parallel 
plot(backdoor_parallel)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParallelWorld-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParallelWorld-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParallelWorld$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
