% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{score.calc.score}
\alias{score.calc.score}
\title{Calculate -log10(p) of each SNP-set by the score test}
\usage{
score.calc.score(
  M.now,
  y,
  X.now,
  ZETA.now,
  LL0,
  Gu,
  Ge,
  P0,
  map,
  kernel.method = "linear",
  kernel.h = "tuned",
  haplotype = TRUE,
  num.hap = NULL,
  test.effect = "additive",
  window.size.half = 5,
  window.slide = 1,
  chi0.mixture = 0.5,
  weighting.center = TRUE,
  weighting.other = NULL,
  gene.set = NULL,
  min.MAF = 0.02,
  count = TRUE
)
}
\arguments{
\item{M.now}{A n.sample x n.mark genotype matrix where n.sample is sample size and n.mark is the number of markers.}

\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X.now}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{ZETA.now}{A list of variance (relationship) matrix (K; \eqn{m \times m}) and its design matrix (Z; \eqn{n \times m}) of random effects. You can use only one kernel matrix.
For example, ZETA = list(A = list(Z = Z, K = K))
Please set names of list "Z" and "K"!}

\item{LL0}{The log-likelihood for the null model.}

\item{Gu}{A \eqn{n \times n} matrix. You should assign \eqn{ZKZ'}, where K is covariance (relationship) matrix and Z is its design matrix.}

\item{Ge}{A \eqn{n \times n} matrix. You should assign identity matrix I (diag(n)).}

\item{P0}{\eqn{n \times n} matrix. The Moore-Penrose generalized inverse of \eqn{SV0S}, where \eqn{S = X(X'X)^{-1}X'} and
\eqn{V0 = \sigma^2_u Gu + \sigma^2_e Ge}. \eqn{\sigma^2_u} and \eqn{\sigma^2_e} are estimators of the null model.}

\item{map}{Data frame of map information where the first column is the marker names,
the second and third column is the chromosome amd map position, and the forth column is -log10(p) for each marker.}

\item{kernel.method}{It determines how to calculate kernel. There are three methods.
\describe{
\item{"gaussian"}{It is the default method. Gaussian kernel is calculated by distance matrix.}
\item{"exponential"}{When this method is selected, exponential kernel is calculated by distance matrix.}
\item{"linear"}{When this method is selected, linear kernel is calculated by A.mat.}
}}

\item{kernel.h}{The hyper parameter for gaussian or exponential kernel.
If kernel.h = "tuned", this hyper parameter is calculated as the median of off-diagonals of distance matrix of genotype data.}

\item{haplotype}{If the number of lines of your data is large (maybe > 100), you should set haplotype = TRUE.
When haplotype = TRUE, haplotype-based kernel will be used for calculating -log10(p).
(So the dimension of this gram matrix will be smaller.)
The result won't be changed, but the time for the calculation will be shorter.}

\item{num.hap}{When haplotype = TRUE, you can set the number of haplotypes which you expect.
Then similar arrays are considered as the same haplotype, and then make kernel(K.SNP) whose dimension is num.hap x num.hap.
When num.hap = NULL (default), num.hap will be set as the maximum number which reflects the difference between lines.}

\item{test.effect}{Effect of each marker to test. You can choose "test.effect" from "additive", "dominance" and "additive+dominance".
You also can choose more than one effect, for example, test.effect = c("additive", "aditive+dominance")}

\item{window.size.half}{This argument decides how many SNPs (around the SNP you want to test) are used to calculated K.SNP.
More precisely, the number of SNPs will be 2 * window.size.half + 1.}

\item{window.slide}{This argument determines how often you test markers. If window.slide = 1, every marker will be tested.
If you want to perform SNP set by bins, please set window.slide = 2 * window.size.half + 1.}

\item{chi0.mixture}{RAINBOWR assumes the test statistic \eqn{l1' F l1} is considered to follow a x chisq(df = 0) + (1 - a) x chisq(df = r).
where l1 is the first derivative of the log-likelihood and F is the Fisher information. And r is the degree of freedom.
The argument chi0.mixture is a (0 <= a < 1), and default is 0.5.}

\item{weighting.center}{In kernel-based GWAS, weights according to the Gaussian distribution (centered on the tested SNP) are taken into account when calculating the kernel if Rainbow = TRUE.
If weighting.center = FALSE, weights are not taken into account.}

\item{weighting.other}{You can set other weights in addition to weighting.center. The length of this argument should be equal to the number of SNPs.
For example, you can assign SNP effects from the information of gene annotation.}

\item{gene.set}{If you have information of gene, you can use it to perform kernel-based GWAS.
You should assign your gene information to gene.set in the form of a "data.frame" (whose dimension is (the number of gene) x 2).
In the first column, you should assign the gene name. And in the second column, you should assign the names of each marker,
which correspond to the marker names of "geno" argument.}

\item{min.MAF}{Specifies the minimum minor allele frequency (MAF).
If a marker has a MAF less than min.MAF, it is assigned a zero score.}

\item{count}{When count is TRUE, you can know how far RGWAS has ended with percent display.}
}
\value{
-log10(p) for each SNP-set
}
\description{
This function calculates -log10(p) of each SNP-set by the score test.
First, the function calculates the score statistic
without solving the multi-kernel mixed model for each SNP-set.
Then it performs the score test by using the fact that the score statistic follows the chi-square distribution.
}
\references{
Listgarten, J. et al. (2013) A powerful and efficient set test
 for genetic markers that handles confounders. Bioinformatics. 29(12): 1526-1533.

Lippert, C. et al. (2014) Greater power and computational efficiency for kernel-based
 association testing of sets of genetic variants. Bioinformatics. 30(22): 3206-3214.
}
