% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupfunctions.R
\name{aqs_credentials}
\alias{aqs_credentials}
\title{aqs_credentials}
\usage{
aqs_credentials(username = NA_character_, key = NA_character_)
}
\arguments{
\item{username}{a R character object which represents the email account that
will be used to connect to the AQS API.}

\item{key}{the key used in conjunction with the username given to connect to
AQS Data Mart.}
}
\value{
None
}
\description{
\lifecycle{stable}
Sets the user credentials for the AQS API. This function
needs to be called once and only once every time this library
is re-loaded. Users must have a valid username and key which
can be obtained through the use of the aqs_sign_up function,
@seealso \code{\link[=aqs_sign_up]{aqs_sign_up()}} to sign up for AQS data mart
credentials.
}
\section{RAQSAPI setup functions}{
NA
}

\examples{
 #to authenticate an existing user the email address
 # "John.Doe@myemail.com" and key = "MyKey"
 #  after calling this function please follow the instructions that are sent
 #  in the verification e-mail before proceeding.
 \dontrun{aqs_credentials(username = "John.Doe@myemail.com",
                              key = "MyKey")
         }
}
