% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAT.R
\name{r.index}
\alias{r.index}
\title{R-index.}
\usage{
r.index(id, homeCountry = NULL, logbase = 2, plot = FALSE)
}
\arguments{
\item{id}{A list obtained with function 'wos'.}

\item{homeCountry}{A character string specifying the country of origin of the researcher. Look at map$country for the complete list. If NULL, the country with most hits in Web of Science is used.}

\item{logbase}{The log base for building the octaves.}

\item{plot}{plots the expected and observed distribution of collaborations according to GDP.}
}
\value{
The r-index value.
}
\description{
Calculates the r-index based on Web of Science data.
}
\details{
The r-index (representativeness) is a measure of the overlap between observed and expected distributions of GDP per capita of collaborating countries (Cardoso et al. subm.).
The abundance distribution of log(GDP per capita) of countries in the collaborators list is calculated (using octaves). This is compared with the global distribution of GDPs by using the overlap of both lists.
}
\examples{
id = wos("C-2482-2012")
r.index(id)
r.index(id, logbase = 10, plot = TRUE)
}
\references{
Cardoso, P., Fukushima, C.S. & Mammola, S. (subm.) Quantifying the international collaboration attitude of scholars.
}
