% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinity.R
\name{affinity}
\alias{affinity}
\alias{setaffinity}
\alias{getaffinity_count}
\alias{getaffinity}
\alias{has_affinity}
\alias{ncores}
\title{Process Affinity}
\usage{
setaffinity(cpus = 1:ncores())

getaffinity_count()

getaffinity()

has_affinity()

ncores()
}
\arguments{
\item{cpus}{Which cpu cores to bind to: vector of integers between 1 and \code{\link[=ncores]{ncores()}}}
}
\description{
Get/set the process's CPU affinity mask. The affinity mask binds the process to
specific core(s) within the machine. Not supported on all systems, \code{\link[=has_affinity]{has_affinity()}}
shows if this is available.
}
\details{
Setting a process affinity allows for restricting the process to only use certain
cores in the machine. The cores are indexed by the operating system as 1 to \code{\link[=ncores]{ncores()}}.
Calling \code{\link[=setaffinity]{setaffinity()}} with no arguments resets the process to use any of the
available cores.

Note that setaffinity is different from setting r_limit values in the sense that
it is not a one-way process. An unprivileged user can change the process affinity
to any value. In order to 'lock' an affinity value, one would have to manipulate
Linux capability value for CAP_SYS_NICE.
}
\examples{
\dontrun{
# Current affinity
ncores()
getaffinity()
getaffinity_count()

# Restrict process to core number 1.
setaffinity(1)
getaffinity()

# Reset
setaffinity()
getaffinity()
}
}
\references{
\href{https://man7.org/linux/man-pages/man2/sched_setaffinity.2.html}{SCHED_SETAFFINITY(2)}
}
