% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc2S.R
\name{oc2S}
\alias{oc2S}
\alias{oc2S.betaMix}
\alias{oc2S.normMix}
\alias{oc2S.gammaMix}
\title{Operating Characteristics for 2 Sample Design}
\usage{
oc2S(prior1, prior2, n1, n2, decision, ...)

\method{oc2S}{betaMix}(prior1, prior2, n1, n2, decision, eps, ...)

\method{oc2S}{normMix}(prior1, prior2, n1, n2, decision, sigma1, sigma2,
  eps = 1e-06, Ngrid = 10, ...)

\method{oc2S}{gammaMix}(prior1, prior2, n1, n2, decision, eps = 1e-06, ...)
}
\arguments{
\item{prior1}{prior for sample 1.}

\item{prior2}{prior for sample 2.}

\item{n1, n2}{sample size of the respective samples.}

\item{decision}{two-sample decision function to use, see \code{\link{oc2Sdecision}}.}

\item{...}{optional arguments.}

\item{eps}{support of random variables are determined as the
interval covering \code{1-eps} probability mass . Defaults to
\code{10^-6}.}

\item{sigma1}{The fixed reference scale of sample 1. If left
unspecified, the default reference scale of the prior 1 is assumed.}

\item{sigma2}{The fixed reference scale of sample 2. If left
unspecified, the default reference scale of the prior 2 is assumed.}

\item{Ngrid}{determines density of discretization grid on which
decision function is evaluated (see below for more details).}
}
\value{
Returns a function which when called with two arguments
\code{theta1} and \code{theta2} will return the frequencies at
which the decision function is evaluated to 1. If called with a
named argument \code{y2} then the decision boundary \eqn{y_{1,c} =
D_1(y_2)} is returned. Note that the returned function takes
vector arguments.
}
\description{
Calculates the frequency at which the decision function is
evaluated to 1 under a specified true scenario and decision
criteria in a two-sample experiment.
}
\details{
The operating characteristics calculate the frequency with
which the decision function is evaluated to 1 under the assumption
of a given true distribution of the data defined by \eqn{\theta_1}
and \eqn{\theta_2}. The specification of the priors, the sample
sizes and the decision function, \eqn{D(y_1,y_2)}, uniquely defines
the decision boundary

\deqn{D_1(y_2) = \sup_{y_1}\{D(y_1,y_2) = 1\},}{D_1(y_2) = sup_{y_1}{D(y_1,y_2) = 1},}

which is the critical value of \eqn{y_{1,c}} conditional on the
value of \eqn{y_2} whenever the decision \eqn{D(y_1,y_2)} function
changes its value from 0 to 1 for a decision function with
\code{lower.tail=TRUE} (otherwise the definition is \eqn{D_1(y_2) =
\inf_{y_1}\{D(y_1,y_2) = 0\}}{D_1(y_2) = inf_{y_1}{D(y_1,y_2) =
0}}). The decision function may change at most at a single critical
value as only one-sided decision functions are supported. Here,
\eqn{y_2} is defined for binary and Poisson endpoints as the
sufficient statistic \eqn{y_2 = \sum_{i=1}^{n_2} y_{2,i}} and for
the normal case as the mean \eqn{\bar{y}_2 = 1/n_2 \sum_{i=1}^{n_2}
y_{2,i}}.

Calling the \code{oc2S} function calculates the decision boundary
\eqn{D_1(y_2)} and returns a function which can be used to evaluate
the decision boundary or evaluate the desired frequency which is
evaluated as

\deqn{ \int f_2(y_2|\theta_2) F_1(D_1(y_2)|\theta_1) dy_2. }

\emph{Note:} Internally, the above integration is carried out
assuming that it suffices to assume a true distribution of the
mean. 

See below for examples and specifics for the supported mixture
priors.
}
\section{Methods (by class)}{
\itemize{
\item \code{betaMix}: Applies for the beta-binomial model with a mixture
beta prior. The calculations use exact expressions. The decision
boundary is returned in alignment with the \code{lower.tail}
argument of the decision function, i.e. for \code{lower.tail=TRUE}
the returned critical value is the largest value \eqn{y_{1,c}} for
which the decision is 1 while for \code{lower.tail=FALSE} the
returned value is the largest value where the decision is still 0
which is compliant with the \code{\link{pbinom}} function. If the
extra argument \code{eps} is defined, then an approximate method is
used which limits the search for the decision boundary to the
region of \eqn{1-10^-6}. This is useful for designs with large
sample sizes where an exact approach is very costly to calculate.

\item \code{normMix}: Used for the normal-normal model with fixed
standard deviation (\eqn{\sigma}) of the sampling space and a
normal mixture prior. As a consequence from the mean assumption,
the calculation discards sampling uncertainty of the second
moment. The function has two extra arguments (with defaults):
\code{eps} (\eqn{10^{-6}}) and \code{Ngrid} (10). The decision
boundary is searched in the region of probability mass
\code{1-eps}, respectively for \eqn{y_1} and \eqn{y_2}. The
continuous decision function is evaluated at discrete steps which
are determined by \eqn{\delta_2 = \sigma_2/\sqrt{N_{grid}}}. Once the
decision boundary is evaluated at the discrete steps, a spline is
used to inter-polate the decision boundary at intermediate points.

\item \code{gammaMix}: Used for the Poisson-gamma case
(Poisson-exponential not yet supported). Takes an extra argument
\code{eps} (\eqn{10^6}) which determines the region of probability
mass \code{1-eps} where the boundary is searched for \eqn{y_1} and
\eqn{y_2}, respectively.
}}

\examples{

# example from Schmidli et al., 2015
dec <- oc2Sdecision(0.975, 0, lower.tail=FALSE)

N <- 40
prior_inf <- mixbeta(c(1, 4, 16))
prior_rob <- robustify(prior_inf, weight=0.2, mean=0.5)
prior_uni <- mixbeta(c(1, 1,  1))
N_ctl <- N - ess(prior_inf, method="morita")

# compare designs with different priors
design_uni <- oc2S(prior_uni, prior_uni, N, N_ctl, dec)
design_inf <- oc2S(prior_uni, prior_inf, N, N_ctl, dec)
design_rob <- oc2S(prior_uni, prior_rob, N, N_ctl, dec)

# decision boundary conditional on outcome of control
design_uni(y2=0:N_ctl)
design_inf(y2=0:N_ctl)
design_rob(y2=0:N_ctl)

# type I error
curve(design_inf(x,x), 0, 1)
curve(design_uni(x,x), lty=2, add=TRUE)
curve(design_rob(x,x), lty=3, add=TRUE)

# power
curve(design_inf(0.2+x,0.2), 0, 0.5)
curve(design_uni(0.2+x,0.2), lty=2, add=TRUE)
curve(design_rob(0.2+x,0.2), lty=3, add=TRUE)


}
\references{
Schmidli H, Gsteiger S, Roychoudhury S, O'Hagan A, Spiegelhalter D, Neuenschwander B.
Robust meta-analytic-predictive priors in clinical trials with historical control information.
\emph{Biometrics} 2014;70(4):1023-1032.
}
\seealso{
Other oc2S: \code{\link{oc2Sdecision}}
}
