% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Links.R
\name{links_Shorten}
\alias{links_Shorten}
\title{Given a long URL, returns a short Bit.ly link.}
\usage{
links_Shorten(longUrl, domain = NULL, showRequestURL = FALSE)
}
\arguments{
\item{longUrl}{- a long URL to be shortened (example: http://betaworks.com/).}

\item{domain}{- (optional) the short domain to use; either bit.ly, j.mp, or bitly.com or
a custom short domain. The default for this parameter is the short domain selected by each
user in their bitly account settings. Passing a specific domain via this parameter will override
the default settings.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
new_hash - designates if this is the first time this long_url was shortened by this user.
The return value will equal 1 the first time a long_url is shortened. It will also then be added
to the user history.

hash - a bitly identifier for long_url which is unique to the given account.

long_url - an echo back of the longUrl request parameter. This may not always be equal to
the URL requested, as some URL normalization may occur (e.g., due to encoding differences, or case
differences in the domain). This long_url will always be functionally identical the the request parameter.

global_hash - a bitly identifier for long_url which can be used to track aggregate stats
across all Bitlinks that point to the same long_url.

url - the actual Bitlink that should be used, and is a unique value for the given Bitly account.
}
\description{
Given a long URL, returns a short Bit.ly link.
}
\note{
The bitly API does not support shortening more than one long URL with a single API call.
Meaning 1 Long URL = 1 Function call.

Long URLs should be URL-encoded. You can not include a longUrl in the request
that has &, ?, #, or other reserved parameters without first encoding it.

The default value for the domain parameter is selected by each user from within their bitly
account settings at \url{https://bitly.com/a/settings/advanced}.

Long URLs should not contain spaces: any longUrl with spaces will be rejected. All spaces
should be either percent encoded %20 or plus encoded +. Note that tabs, newlines and trailing
spaces are all indications of errors. Please remember to strip leading and trailing whitespace
from any user input before shortening.
}
\examples{
options(Bit.ly = "0906523ec6a8c78b33f9310e84e7a5c81e500909")
links_Shorten(longUrl = "http://slovnik.seznam.cz/")
links_Shorten(longUrl = "https://travis-ci.org/dmpe/rbitly/builds/68231423", domain = "j.mp")
}
\seealso{
See \url{http://dev.bitly.com/rate_limiting.html}

See \url{http://dev.bitly.com/links.html#v3_shorten}
}

