% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{split_labels}
\alias{split_labels}
\title{Split row and column labels into nouns and prepositional phrases}
\usage{
split_labels(
  labels,
  notation = RCLabels::bracket_notation,
  prepositions = RCLabels::prepositions
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{notation}{The notation object that describes the labels.
Default is \code{RCLabels::bracket_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions}.}
}
\value{
A list of lists with items named \code{noun} and \code{pp}.
}
\description{
This function is similar to \code{split_pref_suff()} in that it returns a list.
However, this function's list is more detailed than
\code{split_pref_suff()}.
The return value from this function is a list
with the first named item being the prefix (with the name \code{noun})
followed by objects of prepositional phrases
(with names being prepositions that precede the objects).
}
\details{
Unlike \code{split_pref_suff()}, it does not make sense to have a \code{transpose}
argument on \code{split_labels()}.
Labels may not have the same structure,
e.g., they may have different prepositions.
}
\examples{
split_labels(c("a [of b in c]", "d [of e into f]"),
             notation = bracket_notation)
}
