% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-venn.R
\name{plotVennPathway}
\alias{plotVennPathway}
\title{Plot venndiagram from multiple pathway analysis results}
\usage{
plotVennPathway(PAResults, pThreshold = 0.05, useFDR = TRUE)
}
\arguments{
\item{PAResults}{A list of data frames with the results of pathway analysis.}

\item{pThreshold}{The p-value threshold to determine if a pathway is enriched.}

\item{useFDR}{Use the FDR adjusted p-value instead of the raw p-value.}
}
\value{
A ggplot2 object.
}
\description{
Plot a venndiagram from multiple pathway analysis results.
}
\examples{
\donttest{
library(RCPA)

affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")
metaPAResult <- loadData("metaPAResult")

PAResults <- list(
    "Affymetrix - GSE5281" = affyFgseaResult,
    "Agilent - GSE61196" = agilFgseaResult,
    "RNASeq - GSE153873" = RNASeqFgseaResult,
    "Meta-analysis" = metaPAResult
)

PAREsultUps <- lapply(PAResults, function(df) df[df$normalizedScore > 0,])
PAREsultDowns <- lapply(PAResults, function(df) df[df$normalizedScore < 0,])

RCPA::plotVennPathway(PAResults, pThreshold = 0.05) +
    ggplot2::ggtitle("All Significant Pathways")
RCPA::plotVennPathway(PAREsultUps, pThreshold = 0.05) +
    ggplot2::ggtitle("Significantly Up-regulated Pathways")
RCPA::plotVennPathway(PAREsultDowns, pThreshold = 0.05) +
    ggplot2::ggtitle("Significantly Down-regulated Pathways")

}
}
