% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.functions.r
\name{deprecated.functions}
\alias{deprecated.functions}
\alias{AdjR2}
\alias{CI95}
\alias{CI99}
\alias{colPercents}
\alias{compADPQ}
\alias{compmeans}
\alias{crosstab}
\alias{csv.get}
\alias{cut2}
\alias{describe}
\alias{ddply}
\alias{freq}
\alias{imeansC}
\alias{iplotC}
\alias{plotmeans}
\alias{plotmeansC}
\alias{prop.testC}
\alias{SetTextContrastColor}
\alias{somersD}
\alias{spss.get}
\alias{stata.get}
\alias{svyboxplot}
\alias{svychisqC}
\alias{svychisq}
\alias{svyglm}
\alias{svymean}
\alias{svytable}
\alias{wtd.boxplot}
\alias{wtd.chi.sq}
\alias{wtd.t.test}
\alias{wtd.ttestC}
\alias{xtabC}
\alias{xtp}
\alias{xtp.chi2}
\title{Deprecated functions (and how to still use them)}
\usage{
AdjR2()

CI95()

CI99()

colPercents()

compADPQ()

compmeans()

crosstab()

csv.get()

cut2()

describe()

ddply()

freq()

imeansC()

iplotC()

plotmeans()

plotmeansC()

prop.testC()

SetTextContrastColor()

somersD()

spss.get()

stata.get()

svyboxplot()

svychisqC()

svychisq()

svyglm()

svymean()

svytable()

wtd.boxplot()

wtd.chi.sq()

wtd.t.test()

wtd.ttestC()

xtabC()

xtp()

xtp.chi2()
}
\value{
Returned a list of statistics
}
\description{
A number of functions we used in our \emph{R Companion to Political Analysis, 2nd Edition} are not used in \emph{R Companion to Political Analysis, 3rd Edition}.
These deprecated functions have been superseded by new and improved functions in the 3rd Edition. This page lists the deprecated functions and provides reference information for anyone used to using these functions.

\itemize{
\item \strong{AdjR2} calculated adjusted R-Squared statistic.
This function was called after estimating a (weighted) model that did not report adjusted R-Squared statistic.
Adjusted R-Square is now calculated automatically by the \code{\link{regC}} and \code{\link{logregC}} functions.
}

\itemize{
\item \strong{CI95} calculated the 95 percent confidence interval of a sample statistic (returning the upper and lower boundaries).
The \code{\link{CIprop}} and \code{\link{CImean}} functions generate confidence intervals for sample proportions and sample means (default confidence level=95).
To find confidence interval of difference of sample proportions, use \code{\link{testpropsC}}.
To find confidence interval of difference of sample means, use \code{\link{testmeansC}}.
}

\itemize{
\item \strong{CI99} calculated the 99 percent confidence interval of a sample statistic (returning the upper and lower boundaries).
The \code{\link{CIprop}} and \code{\link{CImean}} functions generate confidence intervals for sample proportions and sample means (use argument level=99).
To find confidence interval of difference of sample proportions, use \code{\link{testpropsC}} with argument ci.level=99.
To find confidence interval of difference of sample means, use \code{\link{testmeansC}} with argument ci.level=99.
}

\itemize{
\item \strong{colPercents} calculated column percentages tables for multi-dimensional controlled cross-tabulations, based on function by John Fox. Was used by the xtabC function.
Column percentages are calculated automatically by the \code{\link{crosstabC}} function.
}

\itemize{
\item \strong{compADPQ} calculated a statistic for measure of association in cross-tabulation. This function was called by tablesomersDC function (also deprecated).
The Somers' d measure of association is calculated by \code{\link{crosstabC}} function with somers=T argument.
}

\itemize{
\item \strong{compmeans} was used for mean comparison analysis. The compmeans function was imported from descr package,
See \code{\link[descr]{compmeans}} documentation for details.
For mean comparison analysis, we now feature \code{\link{compmeansC}} which extends the functionality of compmeans to controlled comparisons, graphings, and analysis of variance.
}

\itemize{
\item \strong{crosstab} function was imported from the descr package.
See \code{\link[descr]{crosstab}} documentation for details.
}

\itemize{
\item \strong{csv.get} was used to import files in comma separated value (csv) format. This function was imported from the Hmisc package.
See \code{\link[Hmisc]{csv.get}} documentation for details.
}

\itemize{
\item \strong{cut2} was used to recode numeric variables into ordered factors. This function was imported from the Hmisc package.
See \code{\link[Hmisc]{cut2}} documentation for details.
}

\itemize{
\item \strong{describe} was used to generate descriptive statistics. This function is imported from the Hmisc package.
See \code{\link[Hmisc]{describe}} documentation for details.
}

\itemize{
\item \strong{ddply} was used to generate summary statistics prior to graphing. The function is imported from the plyr package.
See \code{\link[plyr]{ddply}} documentation for details.
}

\itemize{
\item \strong{freq} was used for frequency distribution analysis. This function is imported from the descr package.
See \code{\link[descr]{freq}} documentation for details.
}

\itemize{
\item \strong{imeansC} produced a controlled mean comparison table. Rows defined by values of independent variable and columns defines by values of the control variable.
}

\itemize{
\item \strong{iplotC} generated an interaction plot used brkdn.plot function from plotrix package and svyby function from survey package. Warnings suppressed so the function creates plot without generating intermediate results used to create plot.
}

\itemize{
\item \strong{plotmeans} was used to plot mean values to visualize mean comparisons. This function was imported from the gplots package.
See \code{\link[gplots]{plotmeans}} documentation for details.
}

\itemize{
\item \strong{plotmeansC} plotted the mean values of a dependent variable at different values of nominal or ordinal independent variable. Made use of survey package and gplot package's plotmeans function.
}

\itemize{
\item \strong{prop.testC} was used to test differences of proportions. Deprecated function to test difference of proportions.
}

\itemize{
\item \strong{SetTextContrastColor} determined whether black or white better contrasted with a given color. Used by the \code{\link{Colors}} function.
}

\itemize{
\item \strong{somersD} calculated the Somers' D measure of association statistic.  This function made use of the svytable function from the survey package.
}

\itemize{
\item \strong{spss.get} was used to import datasets in SPSS format. The spss.get function is imported from the Hmisc package.
See \code{\link[Hmisc]{spss.get}} documentation for details.
}

\itemize{
\item \strong{stata.get} was used to import Stata-format datasets. The stata.get function is imported from the Hmisc package.
See \code{\link[Hmisc]{stata.get}} documentation for details.
}

\itemize{
\item \strong{svyboxplot} was used to make a box plot with option for weighted observations. The svyboxplot function is imported from the survey package.
See \code{\link[survey]{svyhist}} documentation for details.
}

\itemize{
\item \strong{svychisq} conducted a Chi-Square test with weighted observations. This function reports chi-squared test statistic based on weighted dataset
}

\itemize{
\item \strong{svychisq} was used to implement a Chi-Square test with weighted observations. The svychisq function is imported from the survey package.
See \code{\link[survey]{svychisq}} documentation for details.
}

\itemize{
\item \strong{svyglm} was used to estimate logistic regression model with weighted observations. The svyglm function is imported from the survey package.
See \code{\link[survey]{svyglm}} documentation for details.
}

\itemize{
\item \strong{svymean} was used to calculate sample mean for weighted observations. The svymean function is imported from the survey package.
See \code{\link[survey]{surveysummary}} documentation for details.
}

\itemize{
\item \strong{svytable} was used to generate cross-tabulations with weighted observations. The svytable function is imported from the survey package.
See survey package documentation for details.
}

\itemize{
\item \strong{wtd.boxplot} generated a box plot with option for weighted observations. Deprecated function to generate box plot
}

\itemize{
\item \strong{wtd.chi.sq} was used for a Chi-Square test with weighted observations. The wtd.chi.sq function is imported from the weights package.
See \code{\link[weights]{wtd.chi.sq}} documentation for details.
}

\itemize{
\item \strong{wtd.t.test} was used to conduct t-tests on sample means with weighted observations. This function is imported from the weights package.
See \code{\link[weights]{wtd.t.test}} documentation for details.
}

\itemize{
\item \strong{wtd.ttestC} was used to test difference of means using t-test. Deprecated function to test difference of means.
}

\itemize{
\item \strong{xtabC} did controlled cross tabulation analysis with optional weights.
}

\itemize{
\item \strong{xtp} generated cross-tabulation of two categorical variables and produced a mosaic plot. Made use of the crosstab function in the descr package.
}

\itemize{
\item \strong{xtp.chi2} did cross tabulation analysis with Chi-Square test. This function made use of the crosstab function from the descr package
}
}
\keyword{internal}
