% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeC.r
\name{describeC}
\alias{describeC}
\title{Generates table of descriptive statistics for one or more variables in a dataset}
\usage{
describeC(x, w, data, digits = 3, printC = FALSE)
}
\arguments{
\item{x}{A variable or list of variables, should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 3).}

\item{printC}{(Optional) Do you want to print table of descriptive statistics to .html file in working directory? (default: FALSE)}
}
\value{
Table of descriptive statistics
}
\description{
Prints a table of descriptive statistics for variable(s) specified with x argument. Works with variables measures at any level but output varies with level of measurement (e.g. you won't get standard deviation for a nominal variable). Option for weighting observations.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 2.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 39-55. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=2}{Tutorials & Resources for Descriptive Statistics}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
 
  library(RCPA3)
  
  \donttest{
  # descriptive statistics for qualitative variables
  describeC(x=world$region)
  
  # descriptive statistics for numeric variable
  describeC(x=world$infant.mortality)
  
  # describe multiple variables in list, with optional w argument
  describeC(x=list(angry.about.things, approve.cong), w=wt, data=nes)
  }
}
