% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{estimate_factor}
\alias{estimate_factor}
\title{Estimates common factor(s) F}
\usage{
estimate_factor(
  robust,
  Y,
  X,
  beta_est,
  g,
  lgfg_list,
  k,
  kg,
  method_estimate_beta,
  method_estimate_factors,
  initialise = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with group membership for all individuals}

\item{lgfg_list}{This is a list (length number of groups) containing FgLg for every group.}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{initialise}{indicator of being in the initialisation phase}

\item{verbose}{when TRUE, it prints messages}
}
\value{
Return a list. The first element contains the k x T matrix with the k estimated common factors. The second element contains either the
robust MacroPCA-based loadings or NA.
}
\description{
The estimator for F, see Anderson (1984), is equal to the first k eigenvectors (multiplied by sqrt(T) due to the restriction F'F/T = I)
associated with first r largest eigenvalues of the matrix WW' (which is of size TxT).
}
