% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{create_true_beta}
\alias{create_true_beta}
\title{Creates beta_true, which contains the true values of beta (= the coefficients of X)}
\usage{
create_true_beta(
  vars,
  NN,
  S_true,
  method_true_beta = "heterogeneous_groups",
  limit_true_groups = 12,
  extra_beta_factor = 1
)
}
\arguments{
\item{vars}{number of observable variables}

\item{NN}{number of time series}

\item{S_true}{number of groups}

\item{method_true_beta}{how the true values of beta are defined: "homogeneous" (equal for all individuals),
"heterogeneous_groups" (equal within groups, and different between groups) or heterogeneous_individuals (different for all individuals)}

\item{limit_true_groups}{Maximum number of true groups in a simulation-DGP for which the code in this package is implemented. Currently equals 12. For application on realworld data this parameter is not relevant.}

\item{extra_beta_factor}{multiplies coefficients in beta_est; default = 1}
}
\value{
matrix with number of rows equal to number of observable variables + 1 (the first row contains the intercept) and number of culumns
equal to the true number of groups.
}
\description{
Creates beta_true, which contains the true values of beta (= the coefficients of X)
}
