% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{estimate_algorithm}
\alias{estimate_algorithm}
\title{This function is a wrapper around the initialization and the estimation part of the algorithm, for one configuration. It is only used for the serialized algorithm.}
\usage{
estimate_algorithm(Y, X, S, k, kg, maxit = 30, robust = TRUE)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{maxit}{maximum limit for the number of iterations}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}
}
\value{
list with
\enumerate{
\item estimated beta
\item vector with group membership
\item matrix with the common factor(s) (contains zero's if there are none estimated)
\item loadings to the common factor(s)
\item list with the group specific factors for each of the groups
\item data.frame with loadings to the group specific factors augmented with group membership and id (to have the order of the time series)
}
}
\description{
This function is a wrapper around the initialization and the estimation part of the algorithm, for one configuration. It is only used for the serialized algorithm.
}
\examples{
\donttest{
set.seed(1)
original_data <- create_data_dgp2(60, 30)
Y <- original_data[[1]]
X <- original_data[[2]]
estimate_algorithm(Y, X, 3, 0, c(3,3,3), maxit = 2, robust = TRUE)
}
}
