% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{estimate_beta}
\alias{estimate_beta}
\title{Estimates beta.}
\usage{
estimate_beta(
  Y,
  X,
  beta_est,
  g,
  lambda_group,
  factor_group,
  lambda,
  comfactor,
  method_estimate_beta = "individual",
  S,
  k,
  kg,
  vars_est,
  robust,
  num_factors_may_vary = TRUE,
  optimize_kappa = FALSE,
  nosetting = FALSE,
  special_case_dgp1 = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{lambda_group}{loadings of the estimated group specific factors}

\item{factor_group}{estimated group specific factors}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{vars_est}{number of variables that will be included in the algorithm and have their coefficient estimated. This is usually equal to the number of observable variables.}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{num_factors_may_vary}{whether or not the number of groupfactors is constant over all groups or not}

\item{optimize_kappa}{indicates if kappa has to be optimized or not (only relevant for the classical algorithm)}

\item{nosetting}{option to remove the recommended setting in lmrob(). It is much faster. Defaults to FALSE.}

\item{special_case_dgp1}{special case for data generated according to dgp 1: it changes the 1st variable in X to 1 (-> intercept). Consequently the estimation of beta needs to be restructured slightly.}
}
\value{
list: 1st element contains matrix (N columns: 1 for each time series of the panel data) with estimated beta_est's. If vars_est is set to 0, the list contains NA.
}
\description{
Update step of algorithm to obtain new estimation for beta. Note that we call it beta_est because beta() exists in base R.
}
\examples{
\donttest{
X <- X_dgp3
Y <- Y_dgp3
# Set estimations for group factors and its loadings, and group membership to the true value
lambda_group <- lambda_group_true_dgp3
factor_group <- factor_group_true_dgp3
g <- g_true_dgp3
# There are no common factors to be estimated  -> but needs placeholder
lambda <- matrix(0, nrow = 1, ncol = 300)
comfactor <- matrix(0, nrow = 1, ncol = 30)
#
# Choose how coefficients of the observable variables are estimated
method_estimate_beta <- "individual"
method_estimate_factors <- "macro"
beta_est <- estimate_beta(
  Y, X, NA, g, lambda_group, factor_group,
  lambda, comfactor,
  S = 3, k = 0, kg = c(3, 3, 3),
  vars_est = 3,
  robust = TRUE
)[[1]]
}
}
