% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{robustpca}
\alias{robustpca}
\title{Function that uses robust PCA and estimates robust factors and loadings.}
\usage{
robustpca(object, number_eigenvectors, KMAX = 20, verbose_robustpca = FALSE)
}
\arguments{
\item{object}{input}

\item{number_eigenvectors}{number of eigenvectors to extract}

\item{KMAX}{The maximal number of principal components to compute. This is a parameter in cellWise::MacroPCA()}

\item{verbose_robustpca}{when TRUE, it prints messages: used for testing (requires Matrix-package when set to TRUE)}
}
\value{
list with as the first element the robust factors and as the second element the robust factor loadings
}
\description{
Contains call to MacroPCA()
}
\details{
Notes:

Different values for kmax give different factors, but the product lambda\emph{factor stays constant. Note that
this number needs to be big enough, otherwise eigen() will be used. Variation in k does give different results for lambda}factor

MacroPCA() crashes with specific values of dim(object). For example when dim(object) = c(193,27).
This is solved with evade_crashes_macropca(), for those problematic dimensions that are already encountered during tests.
}
