% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewSymmetricMatrix.R
\name{skewSymmetricMatrix}
\alias{skewSymmetricMatrix}
\title{\eqn{(3 \times 3)} skew symmetric matrix}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
skewSymmetricMatrix(p)
}
\arguments{
\item{p}{a \eqn{(3 \times 1)} vector \eqn{(\lambda, \mu, \tau)}}
}
\value{
A \eqn{(3 \times 3)} skew symmetric matrix, with :
\itemize{
  \item \eqn{A_{1,2}  = -A_{2,1} = \tau}
  \item \eqn{-A_{1,3} =  A_{3,1} = \mu}
  \item \eqn{A_{3,2}  = -A_{2,3} = \lambda}
}
}
\description{
Return a \eqn{(3 \times 3)} skew symmetric matrix from three parameters \eqn{(\lambda, \mu, \tau)}.
}
\examples{
p <- c(3,7,11)
skewSymmetricMatrix(p)
}
