% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union_sf.R
\name{union_sf}
\alias{union_sf}
\title{Aggregate Polygons in a \code{sf} Object}
\usage{
union_sf(data, key, tolerance = 1, planarCRS = 5514)
}
\arguments{
\item{data}{sf data frame to be aggregated}

\item{key}{name of column to define the output objects}

\item{tolerance}{buffer size for avoiding artefacts (slivers); default is one meter}

\item{planarCRS}{planar CRS for avoiding artefacts (slivers); default is EPSG:5514 = ing. Křovák}
}
\description{
The function aggregates polygons of geometry column of a \code{sf} data frame according to values of a single data column. It has outcome comparable to \code{unionSpatialPolygons} from \code{maptools} package, except that it works on \code{sf} and not \code{sp} objects.
}
\details{
The function has data frame as the first argument, so it is pipe friendly. It retains only geometry and key value, dropping all other columns (they are easy to re-attach using tidyverse/dplyr workflow if required).

During processing the sf data frame is temporarily transformed to planar coordinates and - to avoid artefacts (slivers) at the place of former boundaries - buffered; the default values of \code{planarCRS} and \code{tolerance} should cover most situations in the Czech Republic and near abroad.
}
\examples{
\donttest{

NUTS3 <- union_sf(okresy(), "KOD_CZNUTS3")
  # assembles NUTS3 regions from LAU1 regions of Czech Republic = equivalent to kraje() in geometry

plot(NUTS3)

}
}
