\name{CP_01}
\alias{CP_01}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
transformation of the real-number-CP-decompositions to Binary
}
\description{
transforms CP tensor decomposition generated by real-number methods (like nmu) to Binary by trying
different threshold values.
}
\usage{
CP_01(X, P, pthr = c(0.001, 0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.8),
          testAll = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
 the original tensor as sptensor list(subs,vals,size,nnz)
}
  \item{P}{
a LIST containing the CP transformation
}
  \item{pthr}{
list of threshold values to be tried
}
  \item{testAll}{
  a flag to try all threshold values or stop after having a zero in fp or tp
}
}
\value{
  If it is a LIST, use
  \item{Res }{the tp, fn, fp result of each threshold value.}
  \item{bestSol }{best solution in terms of minimum error (fn+fp)}
}

\author{
Abdelmoneim Amer Desouki
}

\seealso{
 \code{\link{cp_apr}} 
    \code{\link{serial_parCube}} 
    \code{\link{rescal}} 
    \code{\link{rescal_01}} 
    \code{\link{cp_nmu}} 
}

\examples{

trp=rbind(
    cbind('Alex',  'loves', 'Don'),
    cbind('Alex',  'loves', 'Elly'),
    cbind('Alex',  'hates', 'Bob'),
    cbind('Don',   'loves', 'Alex'),
    cbind('Don',   'hates', 'Chris'),
    cbind('Chris', 'hates', 'Bob'),
    cbind('Bob',   'hates', 'Chris'),
    cbind('Elly',  'hates', 'Chris'),
    cbind('Elly',  'hates', 'Bob'),
    cbind('Elly',  'loves', 'Alex')
    )
######
# form tensor as a set of frontal slices (Predicate mode)
    tnsr=getTensor(trp)
    subs=getTnsrijk(tnsr$X)
    X=list(subs=subs,vals=rep(1,nrow(subs)),size=c(5,2,5))
    normX=sqrt(sum(X$vals))
    set.seed(123)
    # NMU decomposition with rank 2
    P1=cp_nmu(X,2)
    res=CP_01(X,P1[[1]])
    Fac=res$sol$u # The factorization
    # TP,FP,FN
    print(sprintf("TP=\%d, FP=\%d, FN=\%d, Threshold=\%f",res$sol$TP,res$sol$FP,res$sol$FN,res$sol$thr))

}