library(shiny)
library(shinythemes)
library(dplyr)
library(ggvis)

shinyUI(
  tags$div(
    navbarPage(
      title = "RDMLedit",
      theme = shinytheme("cerulean"),
      tabPanel("Files",
               fileInput("rdmlFiles",
                         h4(HTML("Upload <b>.RDML</b>, <b>.csv</b>, <b>.lc96p</b>, <b>.xls</b> or <b>.xlsx</b> file(s):")),
                         multiple = TRUE),
               selectizeInput("rdmlFileSlct",
                              "View File",
                              choices = "",
                              options= list(
                                create =TRUE
                              )),
               selectInput("mergeRdmlsSlct",
                           "Merge RDMLs",
                           multiple = TRUE,
                           choices = ""),
               actionButton("mergeBtn",
                            "Merge"),
               textInput("dateMadeText", "Date Made",
                         ""),
               textInput("dateUpdatedText", "Date Updated",
                         ""),
               actionButton("removeRDMLBtn",
                            "Remove RDML"),
               actionButton("updateRDMLBtn",
                            "Update"),
               downloadLink("downloadRDML", "Download RDML"),
               # actionButton("updateDendroPlot",
               #              "Update Dendrogram"),
               plotOutput("dendroRDMLplot")),
      navbarMenu("Metadata",
                 tabPanel("ID",
                          selectizeInput("idSlct",
                                         "Select ID",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("idPublisherText", "Publisher",
                                    ""),
                          textInput("idSerialNumberText", "Serial Number",
                                    ""),
                          textInput("idMD5HashText", "MD5 Hash",
                                    ""),
                          actionButton("removeIDBtn",
                                       "Remove ID")),
                 tabPanel("Experimenter",
                          selectizeInput("experimenterSlct",
                                         "Select Experimenter",
                                         choices = "",
                                         options = list(
                                           create = TRUE
                                         )),
                          
                          textInput("experimenterIdText", "ID",
                                    ""),
                          textInput("experimenterFirstNameText", "First Name",
                                    ""),
                          textInput("experimenterLastNameText", "Last Name",
                                    ""),
                          textInput("experimenterEmailText", "Email",
                                    ""),
                          textInput("experimenterLabNameText", "Lab Name",
                                    ""),
                          textInput("experimenterLabAdressText", "Lab Address",
                                    ""),
                          actionButton("removeExperimenterBtn",
                                       "Remove Experimenter")),
                 tabPanel("Documentation",
                          selectizeInput("documentationSlct",
                                         "Select Documentation",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("documentationIdText", "ID",
                                    ""),
                          textInput("documentationTextText", "Text",
                                    ""),
                          actionButton("removeDocumentationBtn",
                                       "Remove Documentation")),
                 tabPanel("Dye",
                          selectizeInput("dyeSlct",
                                         "Select Dye",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          #                           uiOutput("dyeSlct"),
                          #                           uiOutput("dyeTabWell"),
                          textInput("dyeIdText", "ID",
                                    ""),
                          textInput("dyeDescriptionText", "Text",
                                    ""),
                          actionButton("removeDyeBtn",
                                       "Remove Dye")
                          
                 ),
                 tabPanel("Sample",
                          selectizeInput("sampleSlct",
                                         "Select Sample",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("sampleIdText", "ID",
                                    ""),
                          textInput("sampleDescriptionText", 
                                    "Description",
                                    ""),
                          selectInput("sampleDocumentationSlct",
                                      "Documentation",
                                      multiple = TRUE,
                                      choices = ""),
                          wellPanel(selectizeInput("samplexRefSlct",
                                                   "Select xRef",
                                                   choices = "",
                                                   options= list(
                                                     create =TRUE
                                                   )),
                                    textInput("samplexRefNameText", 
                                              "xRef Name",
                                              ""),
                                    textInput("samplexRefIdText", 
                                              "xRef ID",
                                              ""),
                                    actionButton("removeSamplexRefBtn",
                                                 "Remove xRef")),
                          wellPanel(selectizeInput("sampleAnnotationSlct",
                                                   "Select Annotation",
                                                   choices = "",
                                                   options= list(
                                                     create =TRUE
                                                   )),
                                    textInput("sampleAnnotationPropertyText", 
                                              "Annotation Property",
                                              ""),
                                    textInput("sampleAnnotationValueText", 
                                              "Annotation Value",
                                              ""),
                                    actionButton("removeSampleAnnotationBtn",
                                                 "Remove Annotation")),
                          selectInput("sampleTypeSlct",
                                      "Type",
                                      choices = c("unkn", "ntc",
                                                  "nac",
                                                  "std", "ntp",
                                                  "nrt", "pos",
                                                  "opt")),
                          checkboxInput("sampleInterRunCalibratorChk",
                                        "Inter Run Calibrator",
                                        FALSE),
                          wellPanel("Quantity",
                                    textInput("sampleQuantityValueText", 
                                              "Value",
                                              ""),
                                    selectInput("sampleQuantityUnitSlct",
                                                "Unit",
                                                choices = c("other",
                                                            "cop", "fold",
                                                            "dil", "ng",
                                                            "nMol"))
                          ),
                          checkboxInput("sampleCalibratorSampleChk",
                                        "Calibartor Sample",
                                        FALSE),
                          wellPanel("cDNA Synthesis Method",
                                    textInput("sampleCsmEnzymeText", 
                                              "Enzyme",
                                              ""),
                                    selectInput("sampleCsmPrimingMethodSlct",
                                                "Priming Method",
                                                choices = c("",
                                                            "oligo-dt", "random",
                                                            "target-specific",
                                                            "oligo-dt and random",
                                                            "other")),
                                    checkboxInput("sampleCsmDnaseTreatmentChk",
                                                  "DNAase Treatment",
                                                  FALSE),
                                    selectInput("sampleCsmTccSlct",
                                                "Thermal Cycling Conditions",
                                                choices = "")
                          ),
                          wellPanel("Template Quantity",
                                    textInput("sampleTemplateQuantityConcText", 
                                              "Concentration",
                                              ""),
                                    selectInput("sampleTemplateQuantityNucleotideSlct",
                                                "Nucleotide",
                                                choices = c("",
                                                            "DNA",
                                                            "genomic DNA",
                                                            "cDNA",
                                                            "RNA"))
                          ),
                          actionButton("removeSampleBtn",
                                       "Remove Sample")),
                 tabPanel("Target",
                          selectizeInput("targetSlct",
                                         "Select Target",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("targetIdText", "ID",
                                    ""),
                          textInput("targetDescriptionText", 
                                    "Description",
                                    ""),
                          selectInput("targetDocumentationSlct",
                                      "Documentation",
                                      multiple = TRUE,
                                      choices = ""),
                          wellPanel(selectizeInput("targetxRefSlct",
                                                   "Select xRef",
                                                   choices = "",
                                                   options= list(
                                                     create =TRUE
                                                   )),
                                    textInput("targetxRefNameText", 
                                              "xRef Name",
                                              ""),
                                    textInput("targetxRefIdText", 
                                              "xRef ID",
                                              ""),
                                    actionButton("removetargetxRefBtn",
                                                 "Remove xRef")),
                          selectInput("targetTypeSlct",
                                      "Type",
                                      choices = c("toi",
                                                  "ref")),
                          textInput("targetAemText", 
                                    "Amplification Efficiency Method",
                                    ""),
                          textInput("targetAeText", 
                                    "Amplification Efficiency",
                                    ""),
                          textInput("targetAeSeText", 
                                    "Amplification Efficiency SE",
                                    ""),
                          textInput("targetDetectionLimitText", 
                                    "Detection Limit",
                                    ""),
                          selectInput("targetDyeIdSlct",
                                      "Dye ID",
                                      choices = ""),
                          wellPanel("Sequences",
                                    selectInput("targetSequencesTypeSlct",
                                                "Oligo Type",
                                                choices = c("forwardPrimer",
                                                            "reversePrimer",
                                                            "probe1",
                                                            "probe2",
                                                            "amplicon")),
                                    textInput("targetSequences3PrimeTagText", 
                                              "Tree Prime Tag",
                                              ""),
                                    textInput("targetSequences5PrimeTagText", 
                                              "Five Prime Tag",
                                              ""),
                                    textInput("targetSequencesSequenceText", 
                                              "Sequence",
                                              "")),
                          wellPanel("Commercial Assay",
                                    textInput("targetCaCompanyText", 
                                              "Company",
                                              ""),
                                    textInput("targetCaOrderNumberText", 
                                              "Order Number",
                                              "")),
                          actionButton("removeTargetBtn",
                                       "Remove target")),
                 tabPanel("Thermal Cycling Conditions",
                          selectizeInput("tccSlct",
                                         "Select Thermal Cycling Conditions",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("tccIdText", "ID",
                                    ""),
                          textInput("tccDescriptionText", 
                                    "Description",
                                    ""),
                          selectInput("tccDocumentationSlct",
                                      "Documentation",
                                      multiple = TRUE,
                                      choices = ""),
                          textInput("tccLidTemperatureText", 
                                    "Lid Temperature",
                                    ""),
                          selectInput("tccExperimenterSlct",
                                      "Experimenter",
                                      multiple = TRUE,
                                      choices = ""),
                          wellPanel(selectizeInput("tccStepSlct",
                                                   "Select Step",
                                                   choices = "",
                                                   options= list(
                                                     create =TRUE
                                                   )),
                                    textInput("tccStepNrText", "Step Number",
                                              ""),
                                    textInput("tccStepDescriptionText", 
                                              "Description",
                                              ""),
                                    wellPanel(
                                      selectInput("tccStepTypeSlct",
                                                  "Step Type",
                                                  choices = c("temperature",
                                                              "gradient",
                                                              "loop",
                                                              "pause",
                                                              "lidOpen")),
                                      conditionalPanel(
                                        "input.tccStepTypeSlct == 'gradient'",
                                        textInput("tccStepHighTemperatureText", 
                                                  "High Temperature",
                                                  ""),
                                        textInput("tccStepLowTemperatureText", 
                                                  "Low Temperature",
                                                  "")),
                                      conditionalPanel(
                                        "input.tccStepTypeSlct == 'temperature' || input.tccStepTypeSlct == 'pause'",
                                        textInput("tccStepTemperatureText", 
                                                  "Temperature",
                                                  "")),
                                      conditionalPanel(
                                        "input.tccStepTypeSlct == 'temperature' || input.tccStepTypeSlct == 'gradient'",
                                        textInput("tccStepDurationText", 
                                                  "Duration",
                                                  ""),
                                        textInput("tccStepTemperatureChangeText", 
                                                  "Temperature Change",
                                                  ""),
                                        textInput("tccStepDurationChangeText", 
                                                  "Duration Change",
                                                  ""),
                                        selectInput("tccStepMeasureText", 
                                                    "Measure",
                                                    choices = c("real time",
                                                                "meltcurve")),
                                        textInput("tccStepRampText", 
                                                  "Ramp",
                                                  "")),
                                      conditionalPanel(
                                        "input.tccStepTypeSlct == 'loop'",
                                        textInput("tccStepGotoText", 
                                                  "Go To",
                                                  ""),
                                        textInput("tccStepRepeatText", 
                                                  "Repeat",
                                                  "")),
                                      conditionalPanel(
                                        "input.tccStepTypeSlct == 'lidOpen'",
                                        checkboxInput("tccStepLidOpenChk", 
                                                      "Lid Open",
                                                      FALSE)
                                      ),
                                      actionButton("removeTccStepBtn",
                                                   "Remove Step")
                                    )),
                          actionButton("removeTccBtn",
                                       "Remove Thermal Cycling Conditions")),
                 tabPanel("Experiment", 
                          selectizeInput("experimentSlct",
                                         "Select Experiment",
                                         choices = "",
                                         options= list(
                                           create =TRUE
                                         )),
                          textInput("experimentIdText", "ID",
                                    ""),
                          textInput("experimentDescriptionText", 
                                    "Description",
                                    ""),
                          selectInput("experimentDocumentationSlct",
                                      "Documentation",
                                      multiple = TRUE,
                                      choices = ""),
                          wellPanel(
                            "Run",
                            selectizeInput("runSlct",
                                           "Select Run",
                                           choices = "",
                                           options= list(
                                             create =TRUE
                                           )),
                            textInput("runIdText", "ID",
                                      ""),
                            textInput("runDescriptionText", 
                                      "Description",
                                      ""),
                            selectInput("runDocumentationSlct",
                                        "Documentation",
                                        multiple = TRUE,
                                        choices = ""),
                            selectInput("runExperimenterSlct",
                                        "Experimenter",
                                        multiple = TRUE,
                                        choices = ""),
                            textInput("runInstrumentText", "Instrument",
                                      ""),
                            wellPanel("Data Collection Software",
                                      textInput("runDataCollectionSoftwareNameText",
                                                "Name",
                                                ""),
                                      textInput("runDataCollectionSoftwareVersionText",
                                                "Version",
                                                "")),
                            textInput("runBackgroundDeterminationMethodText",
                                      "Background Determination Method",
                                      ""),
                            selectInput("runCqDetectionMethodSlct",
                                        "Cq Detection Method",
                                        choices = c("",
                                                    "automated threshold and baseline settings",
                                                    "manual threshold and baseline settings",
                                                    "second derivative maximum",
                                                    "other")),
                            selectInput("runTccSlct",
                                        "Thermal Cycling Conditions",
                                        choices = ""),
                            wellPanel(
                              "PCR fromat",
                              textInput("runRowsText", "Rows",
                                        ""),
                              textInput("runColumnsText", "Columns",
                                        ""),
                              selectInput("runRowLabelSlct",
                                          "Row Label",
                                          choices = c("ABC",
                                                      "123",
                                                      "A1a1")),
                              selectInput("runColumnLabelSlct",
                                          "Column Label",
                                          choices = c("123",
                                                      "ABC",
                                                      "A1a1"))
                              
                            ),
                            textInput("runDateText", "Run Date",
                                      ""),
                            wellPanel(
                              "React",
                              selectizeInput("reactSlct",
                                             "Select React",
                                             choices = "",
                                             options= list(
                                               create =TRUE
                                             )),
                              textInput("reactIdText", "ID",
                                        ""),
                              selectInput("reactSampleSlct",
                                          "Sample",
                                          choices = ""),
                              wellPanel(
                                "Data",
                                selectizeInput("dataSlct",
                                               "Select Data",
                                               choices = "",
                                               options= list(
                                                 create =TRUE
                                               )),
                                selectInput("dataTarSlct",
                                            "Target",
                                            choices = ""),
                                textInput("dataCqText", "Cq",
                                          ""),
                                textInput("dataExclText", "Excluded",
                                          ""),
                                textInput("dataEndPtText", "End Point",
                                          ""),
                                textInput("dataBgFluorText", 
                                          "Background Fluorescence",
                                          ""),
                                textInput("dataBgFluorSlpText", 
                                          "Background Fluorescence Slope",
                                          ""),
                                textInput("dataQuantFluorText", 
                                          "Quantification Fluorescence",
                                          ""),
                                actionButton("removeDataBtn",
                                             "Remove Data")
                              ),
                              actionButton("removeReactBtn",
                                           "Remove React")
                            ),
                            actionButton("removeRunBtn",
                                         "Remove Run")
                          ),
                          actionButton("removeExperimentBtn",
                                       "Remove Experiment")
                 )
                 
      ),
      tabPanel("qPCR",
               ggvisOutput("qPCRPlot"),
               dataTableOutput("qPCRDt"),
               value = "adp"),
      tabPanel("Melting",
               ggvisOutput("meltingPlot"),
               dataTableOutput("meltingDt"),
               value = "mdp"),
      tabPanel("Help",
               includeMarkdown("md/help.md")),
      id = "mainNavbar"
    ),
    wellPanel(
      h4("Log:"),
      actionButton("clearLogBtn",
                   "Clear"),
      uiOutput("logText")
    )
  )
)
