% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{dataType}
\alias{dataType}
\title{dataType R6 class.}
\format{An \code{\link{R6Class}} generator object.}
\usage{
dataType
}
\description{
Inherits: \link{rdmlBaseType}.
}
\section{Initialization}{
 \preformatted{dataType$new(tar, cq = NULL, excl = NULL,
adp = NULL, mdp = NULL, endPt = NULL, bgFluor = NULL, bgFluorSlp = NULL,
quantFluor = NULL)}
}

\section{Fields}{
 \describe{
\item{\code{tar}}{\link{idReferencesType}.
  TargetID - A reference to a target.}
  \item{\code{cq}}{\link[checkmate]{checkNumber}.
  Calculated fractional PCR cycle used for downstream quantification.
  Negative values express following condition: Not Available: -1.0 }
  \item{\code{excl}}{\link[checkmate]{checkString}. Excluded. If \code{excl}
  is present, this entry should not be evaluated. Do not set this element
  to \code{FALSE} if the entry is valid. Instead, leave the entire \code{excl}
  element out instead. It may contain a string with a reason for the exclusion.
  Several reasons for exclusion should be
  seperated by semicolons ";".}
  \item{\code{adp}}{\link{adpsType}.}
  \item{\code{mdp}}{\link{mdpsType}.}
  \item{\code{endPt}}{\link[checkmate]{checkNumber}}. Value of the endpoint measurement.
  \item{\code{bgFluor}}{\link[checkmate]{checkNumber}. Background
  fluorescence (the y-intercept of the baseline trend based on the estimated
  background fluorescence). }
  \item{\code{bgFluorSlp}}{\link[checkmate]{checkNumber}.
  Background fluorescence slope - The slope of the baseline trend based on
  the estimated background fluorescence. The element should be absent to
  indicate a slope of 0.0; If this element is present without the \code{bgFluor}
  element it should be ignored. }
  \item{\code{quantFluor}}{\link[checkmate]{checkNumber}. Quantification flourescence -
  The fluorescence value corresponding to the treshold line.} }
}

\section{Methods}{
 \describe{
\item{\code{AsDataFrame(dp.type = "adp")}}{Represents amplification
(\preformatted{dp.type = "adp"}) or melting (\code{dp.type = "mdp"}) data
points as \code{data.frame}}
}
}

\keyword{datasets}
