% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.contingency.test.R
\name{bootstrap.contingency.test}
\alias{bootstrap.contingency.test}
\title{Performs a bootstrap test of independance between two categorical variables}
\usage{
bootstrap.contingency.test(
  rds.data,
  row.var,
  col.var,
  number.of.bootstrap.samples = 1000,
  weight.type = c("HCG", "RDS-II", "Arithmetic Mean"),
  table.only = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{rds.data}{an rds.data.frame}

\item{row.var}{the name of the first categorical variable}

\item{col.var}{the name of the second categorical variable}

\item{number.of.bootstrap.samples}{The number of simulated boootstrap populations}

\item{weight.type}{The type of weighting to use for the contningency table. Only large sample methods are allowed.}

\item{table.only}{only returns the weighted table, without bootstrap.}

\item{verbose}{level of output}

\item{...}{Additional parameters for compute_weights}
}
\description{
Performs a bootstrap test of independance between two categorical variables
}
\details{
This function first estimates a Homophily Configuration Graph model for the underlying
network under the assumption that the two variables are independant and that the population size is large. 
It then draws bootstrap
RDS samples from this population distribution and calculates the chi.squared statistic on
the weighted contingency table. Weights are calculated using the HCG estimator assuming a large population size.
}
\examples{
data(faux)
bootstrap.contingency.test(rds.data=faux, row.var="X", col.var="Y",
  number.of.bootstrap.samples=50, verbose=FALSE)
}
