% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPmix.R
\name{NPmix}
\alias{NPmix}
\title{Normal mixture with Poisson sample size via Kiefer Wolfowitz NPMLE}
\usage{
NPmix(x, m, v = 50, u = 50, weights = NULL, ...)
}
\arguments{
\item{x}{observed response for Gaussian observations}

\item{m}{Number of trials for Poisson observations}

\item{v}{Grid Values for the Gaussian means mixing distribution defaults to equal
spacing of length v on [min(x) + eps, max(x) - eps], if v is scalar.}

\item{u}{Grid Values for the Poisson rate mixing distribution defaults to equal
spacing of length u on [min(m) + eps, max(m) - eps], if u is scalar.}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{Other arguments to be passed to KWDual to control optimization}
}
\value{
An object of class density with components: 
	\item{v}{grid points of evaluation of the success probabilities} 
	\item{u}{grid points of evaluation of the Poisson rate for number of trials} 
	\item{y}{function values of the mixing density at (v,u)} 
	\item{g}{estimates of the mixture density at the distinct data values} 
	\item{logLik}{Log Likelihood value at the estimate}
	\item{status}{exit code from the optimizer}
}
\description{
Interior point solution of Kiefer-Wolfowitz NPMLE for mixture of Normal/Poissons
}
\details{
The joint distribution of the means and the number of trials determining sample standard
deviations is estimated.  The grid specification for means is as for \code{GLmix}
whereas the grid for the Poisson rate parameters by default depends on the support of the 
observed trials.  There is no predict method as yet.  See \code{demo(NPmix1)}.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. 27, (1956), 887-906.
}
\author{
R. Koenker and J. Gu
}
\keyword{nonparametric}
