% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{add_supertbl_toc}
\alias{add_supertbl_toc}
\title{Add the supertbl table of contents sheet}
\usage{
add_supertbl_toc(
  wb,
  supertbl,
  include_metadata_sheet,
  add_labelled_column_headers,
  table_style,
  column_width,
  na_replace
)
}
\arguments{
\item{wb}{An \code{openxlsx2} workbook object}

\item{supertbl}{a supertibble generated using \code{\link[=read_redcap]{read_redcap()}}}

\item{include_metadata_sheet}{Include a sheet capturing the combined output of the
supertibble \code{redcap_metadata}.}

\item{add_labelled_column_headers}{Whether or not to include labelled outputs.}

\item{table_style}{Any excel table style name or "none" (see "formatting"
in \code{\link[openxlsx2:wb_add_data_table]{openxlsx2::wb_add_data_table()}}). Default "tableStyleLight8".}

\item{column_width}{Width to set columns across the workbook. Default
"auto", otherwise a numeric value. Standard Excel is 8.43.}

\item{na_replace}{The value used to replace \code{NA} values in \code{supertbl}. The default is "".}
}
\value{
A dataframe
}
\description{
Internal helper function. Adds appropriate elements to \code{wb} object. Returns
a dataframe.
}
\keyword{internal}
