% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotInit}
\alias{plotInit}
\title{Plot initialization}
\usage{
plotInit(init, alpha = NULL, trueValue = NULL)
}
\arguments{
\item{init}{outputs from \code{\link{initStrat}} function.}

\item{alpha}{named list of named vector "\code{alpha0}", "\code{alpha1}" (all \code{alpha1} are mandatory). The name of \code{alpha$alpha0} and \code{alpha$alpha1} are the observation model names from the monolix project to which they are linked (if the observations models are defined whithout intercept, alpha$alpha0 need to be set to the vector NULL).}

\item{trueValue}{(for simulation purpose) named vector containing the true value of regularization parameter.}
}
\value{
log-likelihood value for all groups of genes tested.
}
\description{
Plot initialization
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

init <- initStrat(project,alpha,ObsModel.transfo,seed=1710)

plotInit(init)
}
}
\seealso{
\code{\link{initStrat}}.
}
