/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import javalain.algorithmegenetique.Chromosome;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.GeneComplexe;

public class ChromosomeFixe
extends Chromosome {
    public static final int GENE = 1;
    public static final int MELANGE = 16;
    public static final int CARACTERE = 257;
    private static final int SIMPLE = 17;
    private static final int COMPLEXE = 273;
    private int type;
    private Gene[] tabGene;
    private int nbGene;
    protected int modeCroisement;

    public ChromosomeFixe(int taille, int mode_crois) {
        this.nbGene = taille;
        this.tabGene = new Gene[taille];
        this.type = 17;
        this.modeCroisement = mode_crois;
    }

    public ChromosomeFixe(Gene g, int taille, int mode_crois) {
        this.nbGene = taille;
        this.tabGene = new Gene[taille];
        for (int i = 0; i < taille; ++i) {
            this.tabGene[i] = g.creer();
        }
        this.type = g instanceof GeneComplexe ? 273 : 17;
        this.modeCroisement = mode_crois;
    }

    public void addGene(Gene ge) {
        int i;
        for (i = 0; i < this.nbGene && this.tabGene[i] != null; ++i) {
        }
        if (i == this.nbGene) {
            throw new IndexOutOfBoundsException("ChromosomeFixe, addGene (Gene ge) : impossible d'ajouter un Gene, le ChromosomeFixe est plein.");
        }
        this.tabGene[i] = ge;
    }

    public Gene getGene(int i) {
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeFixe, getGene (int i) : indice 'i' hors des limites.");
        }
        return this.tabGene[i];
    }

    public Gene setGene(int i, Gene ge) {
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeFixe, setGene (int i, Gene ge) : indice 'i' hors des limites.");
        }
        if (!this.tabGene[i].getClass().isInstance(ge)) {
            throw new IllegalArgumentException("ChromosomeFixe, setGene (int i, Gene ge) : le nouveau gene n'est pas du meme type que le gene remplace.");
        }
        Gene g = this.tabGene[i];
        this.tabGene[i] = ge;
        return g;
    }

    public int size() {
        return this.nbGene;
    }

    public Chromosome[] croisement(Chromosome parent) {
        ChromosomeFixe cf1;
        ChromosomeFixe cf0;
        try {
            cf0 = (ChromosomeFixe)this.clone();
            cf1 = (ChromosomeFixe)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        cf0.tabGene = new Gene[this.nbGene];
        cf1.tabGene = new Gene[this.nbGene];
        switch (this.modeCroisement & this.type) {
            case 1: {
                int i;
                ChromosomeFixe cf_parent = (ChromosomeFixe)parent;
                int point = (int)(Math.random() * (double)(this.nbGene - 1)) + 1;
                for (i = 0; i < point; ++i) {
                    cf0.tabGene[i] = this.tabGene[i].copier();
                    cf1.tabGene[i] = cf_parent.tabGene[i].copier();
                }
                for (i = point; i < this.nbGene; ++i) {
                    cf0.tabGene[i] = cf_parent.tabGene[i].copier();
                    cf1.tabGene[i] = this.tabGene[i].copier();
                }
                break;
            }
            case 257: {
                int i;
                ChromosomeFixe cf_parent = (ChromosomeFixe)parent;
                int point = (int)(Math.random() * (double)this.nbGene);
                for (i = 0; i < point; ++i) {
                    cf0.tabGene[i] = this.tabGene[i].copier();
                    cf1.tabGene[i] = cf_parent.tabGene[i].copier();
                }
                GeneComplexe[] gc = ((GeneComplexe)this.tabGene[point]).croisement((GeneComplexe)cf_parent.tabGene[point]);
                cf0.tabGene[i] = gc[0];
                cf1.tabGene[i] = gc[1];
                for (i = point + 1; i < this.nbGene; ++i) {
                    cf0.tabGene[i] = cf_parent.tabGene[i].copier();
                    cf1.tabGene[i] = this.tabGene[i].copier();
                }
                break;
            }
            case 16: {
                ChromosomeFixe cf_parent = (ChromosomeFixe)parent;
                int point1 = (int)(Math.random() * (double)(this.nbGene + 1));
                int point2 = (int)(Math.random() * (double)(this.nbGene + 1));
                if (point1 < point2) {
                    int i;
                    for (i = 0; i < point1; ++i) {
                        cf0.tabGene[i] = this.tabGene[i].copier();
                        cf1.tabGene[i] = cf_parent.tabGene[i].copier();
                    }
                    for (i = point1; i < point2; ++i) {
                        Gene g;
                        cf0.tabGene[i] = g = this.tabGene[i].melanger(cf_parent.tabGene[i]);
                        cf1.tabGene[i] = g.copier();
                    }
                    for (i = point2; i < this.nbGene; ++i) {
                        cf0.tabGene[i] = this.tabGene[i].copier();
                        cf1.tabGene[i] = cf_parent.tabGene[i].copier();
                    }
                } else {
                    Gene g;
                    int i;
                    for (i = 0; i < point2; ++i) {
                        cf0.tabGene[i] = g = this.tabGene[i].melanger(cf_parent.tabGene[i]);
                        cf1.tabGene[i] = g.copier();
                    }
                    for (i = point2; i < point1; ++i) {
                        cf0.tabGene[i] = this.tabGene[i].copier();
                        cf1.tabGene[i] = cf_parent.tabGene[i].copier();
                    }
                    for (i = point1; i < this.nbGene; ++i) {
                        cf0.tabGene[i] = g = this.tabGene[i].melanger(cf_parent.tabGene[i]);
                        cf1.tabGene[i] = g.copier();
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("ChromosomeFixe, croisement (Chromosome parent, int mode) : mode de croisement incorrect.");
            }
        }
        Chromosome[] cf = new ChromosomeFixe[]{cf0, cf1};
        return cf;
    }

    public boolean mutation(double Pm) {
        if (Math.random() <= Pm) {
            this.tabGene[(int)(Math.random() * (double)this.nbGene)].mutation();
            return true;
        }
        return false;
    }

    public Chromosome copier() {
        try {
            ChromosomeFixe cf = (ChromosomeFixe)this.clone();
            cf.tabGene = new Gene[this.nbGene];
            for (int i = 0; i < this.nbGene; ++i) {
                cf.tabGene[i] = this.tabGene[i].copier();
            }
            return cf;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Chromosome creer() {
        try {
            ChromosomeFixe cf = (ChromosomeFixe)this.clone();
            cf.tabGene = new Gene[this.nbGene];
            for (int i = 0; i < this.nbGene; ++i) {
                cf.tabGene[i] = this.tabGene[i].creer();
            }
            return cf;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean estEgalA(Chromosome c) {
        ChromosomeFixe cf = (ChromosomeFixe)c;
        if (this.nbGene == cf.nbGene) {
            for (int i = 0; i < this.nbGene; ++i) {
                if (this.tabGene[i].estEgalA(cf.tabGene[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public StringBuilder afficher() {
        int taille = this.nbGene - 1;
        StringBuilder sb = new StringBuilder("<debut<");
        for (int i = 0; i < taille; ++i) {
            sb.append((CharSequence)this.tabGene[i].afficher());
            sb.append(" ");
        }
        sb.append((CharSequence)this.tabGene[taille].afficher());
        sb.append(">fin>");
        return sb;
    }

    public boolean estPlusGeneralQue(Chromosome c) {
        ChromosomeFixe cf = (ChromosomeFixe)c;
        if (this.nbGene == cf.nbGene) {
            for (int i = 0; i < this.nbGene; ++i) {
                if (this.tabGene[i].estPlusGeneralQue(cf.tabGene[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

