/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import epp.EPPLab;
import epp.EvolutionPP;
import epp.ParametrePP;
import ihm.Analyse;
import ihm.FiltreTXT;
import ihm.Recherche;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javalain.algorithmegenetique.ihm.composant.JButtonEA;
import javalain.algorithmegenetique.ihm.composant.JComboBoxEA;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPar;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPres;
import javalain.algorithmegenetique.ihm.composant.JRadioButtonEA;
import javalain.algorithmegenetique.ihm.composant.JTextFieldEA;
import javalain.algorithmegenetique.ihm.composant.TitledBorderEA;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import util.FileUtils;
import util.GuiUtils;
import util.MsgUtils;

public class Ihm
extends JFrame
implements ItemListener {
    protected Recherche frRecherche;
    protected Analyse frAnalyse;
    private TitledBorderEA tbRecherche;
    private JLabelEAPres lblMode;
    private JRadioButtonEA rbExpert;
    private JRadioButtonEA rbDebutant;
    private JRadioButtonEA rbExploration;
    private JLabelEAPres lblStructure;
    private ButtonGroup groupStructure;
    private JRadioButtonEA rbGroupes;
    private JRadioButtonEA rbAtypiques;
    private JLabelEAPres lblDonnees;
    private JComboBoxEA cbListeDonnees;
    protected Vector<String> l_fichiers_donnees;
    private JButtonEA btParcourir;
    private TitledBorderEA tbAnalyse;
    private JLabelEAPar lblRepertoire;
    private JTextFieldEA txtChemin;
    private JButtonEA btParcourirRep;
    private JRadioButtonEA rbAnalyse;
    private JComboBoxEA cbListeSortie;
    protected Vector<String> l_fichiers_sortie;
    private JButtonEA btOk;
    private JComboBoxEA cbLangue;
    private EvolutionPP evolution;
    private ParametrePP parametre;

    public Ihm(int x, int y, EvolutionPP e, ParametrePP p) {
        this.setTitle("EPP-Lab");
        this.setLocation(x, y);
        this.setResizable(false);
        this.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                EPPLab.savePrefs(Ihm.this.parametre, Ihm.this.getX(), Ihm.this.getY());
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
                Ihm.this.cbListeDonnees.updateUI();
                Ihm.this.cbListeSortie.updateUI();
            }
        });
        this.evolution = e;
        this.parametre = p;
        Container conteneur = this.getContentPane();
        conteneur.setLayout(new BoxLayout(conteneur, 1));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        ButtonGroup groupMode = new ButtonGroup();
        int ligne = 0;
        JPanel jpRecherche = new JPanel();
        jpRecherche.setLayout(gb);
        this.tbRecherche = new TitledBorderEA(EPPLab.msg.getString("tb.recherche"));
        jpRecherche.setBorder((Border)this.tbRecherche);
        Component espace = Box.createHorizontalStrut(150);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 23;
        gb.setConstraints(espace, gbc);
        jpRecherche.add(espace);
        this.lblMode = new JLabelEAPres(EPPLab.msg.getString("label.mode"));
        gb.setConstraints((Component)this.lblMode, gbc);
        jpRecherche.add((Component)this.lblMode);
        this.rbExpert = new JRadioButtonEA(EPPLab.msg.getString("rb.expert"));
        this.rbExpert.addItemListener((ItemListener)this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints((Component)this.rbExpert, gbc);
        jpRecherche.add((Component)this.rbExpert);
        groupMode.add((AbstractButton)this.rbExpert);
        this.rbDebutant = new JRadioButtonEA(EPPLab.msg.getString("rb.debutant"));
        this.rbDebutant.addItemListener((ItemListener)this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints((Component)this.rbDebutant, gbc);
        jpRecherche.add((Component)this.rbDebutant);
        groupMode.add((AbstractButton)this.rbDebutant);
        this.rbExploration = new JRadioButtonEA(EPPLab.msg.getString("rb.comparaison"));
        this.rbExploration.setEnabled(false);
        this.rbExploration.addItemListener((ItemListener)this);
        gbc.gridy = ligne;
        gb.setConstraints((Component)this.rbExploration, gbc);
        jpRecherche.add((Component)this.rbExploration);
        groupMode.add((AbstractButton)this.rbExploration);
        ligne = 0;
        espace = Box.createHorizontalStrut(150);
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(espace, gbc);
        jpRecherche.add(espace);
        this.lblStructure = new JLabelEAPres(EPPLab.msg.getString("label.structure"));
        this.lblStructure.setEnabled(false);
        gb.setConstraints((Component)this.lblStructure, gbc);
        jpRecherche.add((Component)this.lblStructure);
        this.groupStructure = new ButtonGroup();
        this.rbGroupes = new JRadioButtonEA(EPPLab.msg.getString("rb.groupes"));
        this.rbGroupes.setEnabled(false);
        this.rbGroupes.addItemListener((ItemListener)this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints((Component)this.rbGroupes, gbc);
        jpRecherche.add((Component)this.rbGroupes);
        this.groupStructure.add((AbstractButton)this.rbGroupes);
        this.rbAtypiques = new JRadioButtonEA(EPPLab.msg.getString("rb.atypiques"));
        this.rbAtypiques.setEnabled(false);
        this.rbAtypiques.addItemListener((ItemListener)this);
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints((Component)this.rbAtypiques, gbc);
        jpRecherche.add((Component)this.rbAtypiques);
        this.groupStructure.add((AbstractButton)this.rbAtypiques);
        ligne = 0;
        espace = Box.createHorizontalStrut(150);
        gbc.gridx = 2;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(espace, gbc);
        jpRecherche.add(espace);
        this.lblDonnees = new JLabelEAPres(EPPLab.msg.getString("label.donnees"));
        this.lblDonnees.setEnabled(false);
        gb.setConstraints((Component)this.lblDonnees, gbc);
        jpRecherche.add((Component)this.lblDonnees);
        this.l_fichiers_donnees = FileUtils.listeFichiers((File)new File(this.parametre.rep_donnees));
        this.l_fichiers_donnees.add(0, EPPLab.msg.getString("cb.listeDonnees"));
        this.cbListeDonnees = new JComboBoxEA(this.l_fichiers_donnees);
        this.cbListeDonnees.setMaximumSize(new Dimension(210, 23));
        this.cbListeDonnees.setPreferredSize(new Dimension(210, 23));
        this.cbListeDonnees.setSelectedIndex(0);
        this.cbListeDonnees.setEnabled(false);
        this.cbListeDonnees.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Ihm.this.cbListeDonnees.getItemCount() != 0) {
                    if (Ihm.this.cbListeDonnees.getSelectedItem().equals(EPPLab.msg.getString("cb.listeDonnees"))) {
                        Ihm.this.btOk.setEnabled(false);
                        ((Ihm)Ihm.this).parametre.ficherDeDonnees = null;
                    } else {
                        Ihm.this.btOk.setEnabled(true);
                        Ihm.this.getRootPane().setDefaultButton((JButton)Ihm.this.btOk);
                        ((Ihm)Ihm.this).parametre.ficherDeDonnees = (String)Ihm.this.cbListeDonnees.getSelectedItem();
                    }
                } else {
                    Ihm.this.btOk.setEnabled(false);
                }
            }
        });
        gbc.fill = 2;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints((Component)this.cbListeDonnees, gbc);
        jpRecherche.add((Component)this.cbListeDonnees);
        this.btParcourir = new JButtonEA(EPPLab.msg.getString("bt.parcourir"));
        this.btParcourir.setEnabled(false);
        this.btParcourir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Ihm.this.parcourirFichier();
            }
        });
        gbc.fill = 0;
        gbc.gridy = ligne;
        gbc.gridheight = 2;
        gbc.anchor = 1536;
        gb.setConstraints((Component)this.btParcourir, gbc);
        jpRecherche.add((Component)this.btParcourir);
        conteneur.add(jpRecherche);
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel jpAnalyse = new JPanel();
        jpAnalyse.setLayout(gb);
        this.tbAnalyse = new TitledBorderEA(EPPLab.msg.getString("tb.analyse"));
        jpAnalyse.setBorder((Border)this.tbAnalyse);
        this.rbAnalyse = new JRadioButtonEA(EPPLab.msg.getString("rb.analyse"));
        this.rbAnalyse.addItemListener((ItemListener)this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = GuiUtils.INSETS_0500;
        gbc.anchor = 512;
        gb.setConstraints((Component)this.rbAnalyse, gbc);
        jpAnalyse.add((Component)this.rbAnalyse);
        groupMode.add((AbstractButton)this.rbAnalyse);
        this.l_fichiers_sortie = FileUtils.listeFichiers((File)new File(this.parametre.rep_sortie));
        this.l_fichiers_sortie.add(0, EPPLab.msg.getString("cb.listeSortie"));
        this.cbListeSortie = new JComboBoxEA(this.l_fichiers_sortie);
        this.cbListeSortie.setMaximumSize(new Dimension(350, 23));
        this.cbListeSortie.setPreferredSize(new Dimension(350, 23));
        this.cbListeSortie.setSelectedIndex(0);
        this.cbListeSortie.setEnabled(false);
        this.cbListeSortie.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Ihm.this.cbListeSortie.getItemCount() != 0) {
                    if (Ihm.this.cbListeSortie.getSelectedItem().equals(EPPLab.msg.getString("cb.listeSortie"))) {
                        Ihm.this.btOk.setEnabled(false);
                    } else {
                        Ihm.this.btOk.setEnabled(true);
                        Ihm.this.getRootPane().setDefaultButton((JButton)Ihm.this.btOk);
                    }
                } else {
                    Ihm.this.btOk.setEnabled(false);
                }
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = GuiUtils.INSETS_0500;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)this.cbListeSortie, gbc);
        jpAnalyse.add((Component)this.cbListeSortie);
        conteneur.add(jpAnalyse);
        JPanel jpDirWork = new JPanel();
        jpDirWork.setLayout(new BorderLayout(4, 4));
        jpDirWork.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 2));
        this.lblRepertoire = new JLabelEAPar(EPPLab.msg.getString("label.repertoireResult"));
        jpDirWork.add((Component)this.lblRepertoire, "West");
        this.txtChemin = new JTextFieldEA(10);
        this.txtChemin.setText(this.parametre.rep_travail);
        jpDirWork.add((Component)this.txtChemin, "Center");
        this.btParcourirRep = new JButtonEA(EPPLab.msg.getString("bt.modifier"));
        this.btParcourirRep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Ihm.this.parcourirRepertoire();
            }
        });
        jpDirWork.add((Component)this.btParcourirRep, "East");
        conteneur.add(jpDirWork);
        JPanel jpOk = new JPanel();
        jpOk.setLayout(new BorderLayout());
        jpOk.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
        String[] langue = new String[]{"fr", "en", "es"};
        this.cbLangue = new JComboBoxEA(langue);
        this.cbLangue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cde = (String)Ihm.this.cbLangue.getSelectedItem();
                Locale locale = new Locale("en", "US");
                if (cde.equals("fr")) {
                    locale = new Locale("fr", "FR");
                }
                if (cde.equals("es")) {
                    locale = new Locale("es", "ES");
                }
                EPPLab.msg = ResourceBundle.getBundle("ihm/MessagesBundle", locale);
                Ihm.this.setTitle(EPPLab.msg.getString("frame.interface"));
                Ihm.this.btParcourir.setText(EPPLab.msg.getString("bt.parcourir"));
                Ihm.this.btParcourirRep.setText(EPPLab.msg.getString("bt.modifier"));
                Ihm.this.btOk.setText(EPPLab.msg.getString("bt.ok"));
                Ihm.this.lblDonnees.setText(EPPLab.msg.getString("label.donnees"));
                Ihm.this.lblMode.setText(EPPLab.msg.getString("label.mode"));
                Ihm.this.lblRepertoire.setText(EPPLab.msg.getString("label.repertoireResult"));
                Ihm.this.lblStructure.setText(EPPLab.msg.getString("label.structure"));
                Ihm.this.rbAnalyse.setText(EPPLab.msg.getString("rb.analyse"));
                Ihm.this.rbAtypiques.setText(EPPLab.msg.getString("rb.atypiques"));
                Ihm.this.rbExploration.setText(EPPLab.msg.getString("rb.comparaison"));
                Ihm.this.rbDebutant.setText(EPPLab.msg.getString("rb.debutant"));
                Ihm.this.rbExpert.setText(EPPLab.msg.getString("rb.expert"));
                Ihm.this.rbGroupes.setText(EPPLab.msg.getString("rb.groupes"));
                Ihm.this.tbAnalyse.setTitle(EPPLab.msg.getString("tb.analyse"));
                Ihm.this.tbRecherche.setTitle(EPPLab.msg.getString("tb.recherche"));
                Ihm.this.repaint();
                Ihm.this.pack();
            }
        });
        jpOk.add((Component)this.cbLangue, "West");
        this.btOk = new JButtonEA(EPPLab.msg.getString("bt.ok"));
        this.btOk.setEnabled(false);
        this.btOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Ihm.this.cbLangue.setEnabled(false);
                if (Ihm.this.rbGroupes.isSelected() || Ihm.this.rbAtypiques.isSelected()) {
                    if (Ihm.this.frRecherche == null) {
                        Ihm.this.frRecherche = new Recherche(Ihm.this.getX(), Ihm.this.getY(), Ihm.this.evolution, Ihm.this.parametre, Ihm.this);
                        Ihm.this.evolution.setFrRecherche(Ihm.this.frRecherche);
                    }
                    Ihm.this.frRecherche.initialise();
                    Ihm.this.frRecherche.setVisible(true);
                } else {
                    if (Ihm.this.frAnalyse == null) {
                        Ihm.this.frAnalyse = new Analyse(Ihm.this.getX(), Ihm.this.getY(), (String)Ihm.this.cbListeSortie.getSelectedItem(), Ihm.this);
                    }
                    Ihm.this.frAnalyse.setVisible(true);
                    Ihm.this.frAnalyse.initialise((String)Ihm.this.cbListeSortie.getSelectedItem());
                }
                Ihm.this.setVisible(false);
            }
        });
        jpOk.add((Component)this.btOk, "East");
        conteneur.add(jpOk);
        this.pack();
        this.setVisible(true);
        this.rbExpert.setSelected(true);
        this.rbGroupes.setSelected(true);
        this.cbListeDonnees.setSelectedItem((Object)"olive.txt");
    }

    public ParametrePP getParametre() {
        return this.parametre;
    }

    public boolean isModeExpert() {
        return this.rbExpert.isSelected();
    }

    public String getRepertoire() {
        return this.txtChemin.getText();
    }

    public boolean isModeDebutant() {
        return this.rbDebutant.isSelected();
    }

    public boolean isRechercheGroupe() {
        return this.rbGroupes.isSelected();
    }

    private void parcourirFichier() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FiltreTXT());
        int returnVal = fc.showDialog(this, EPPLab.msg.getString("bt.ajouter"));
        if (returnVal == 0) {
            File src = fc.getSelectedFile();
            File dest = new File(this.parametre.rep_donnees + File.separatorChar + src.getName());
            if (dest.exists()) {
                Object[] options = new Object[]{EPPLab.msg.getString("rb.oui"), EPPLab.msg.getString("bt.annuler")};
                int choix = JOptionPane.showOptionDialog(this, EPPLab.msg.getString("showOptionDialog.ajoutDonnee") + "\n" + EPPLab.msg.getString("showOptionDialog.remplacer"), EPPLab.msg.getString("showOptionDialog.attention"), 0, 3, null, options, options[0]);
                if (choix == 0) {
                    try {
                        FileUtils.copierFichier((File)src, (File)dest);
                    }
                    catch (IOException e) {
                        MsgUtils.erreur((Window)this, (String)(EPPLab.msg.getString("showOptionDialog.erreurCopie") + src.getName()), (String)EPPLab.msg.getString("showOptionDialog.erreur"));
                    }
                    this.cbListeDonnees.setSelectedItem((Object)src.getName());
                }
            } else {
                try {
                    FileUtils.copierFichier((File)src, (File)dest);
                }
                catch (IOException e) {
                    MsgUtils.erreur((Window)this, (String)(EPPLab.msg.getString("showOptionDialog.erreurCopie") + src.getName()), (String)EPPLab.msg.getString("showOptionDialog.erreur"));
                }
                this.cbListeDonnees.addItem((Object)src.getName());
                this.cbListeDonnees.setSelectedItem((Object)src.getName());
            }
        }
    }

    private void parcourirRepertoire() {
        JFileChooser fc = new JFileChooser(this.parametre.rep_travail);
        fc.setFileSelectionMode(1);
        int returnVal = fc.showDialog(this, EPPLab.msg.getString("bt.ajouter"));
        if (returnVal == 0) {
            File src = fc.getSelectedFile();
            this.parametre.updatePath(src.getAbsolutePath());
            FileUtils.listeFichiers((File)new File(this.parametre.rep_donnees), this.l_fichiers_donnees);
            this.l_fichiers_donnees.add(0, EPPLab.msg.getString("cb.listeDonnees"));
            FileUtils.listeFichiers((File)new File(this.parametre.rep_sortie), this.l_fichiers_sortie);
            this.l_fichiers_sortie.add(0, EPPLab.msg.getString("cb.listeSortie"));
            this.cbListeDonnees.updateUI();
            this.cbListeDonnees.setSelectedIndex(0);
            this.cbListeSortie.updateUI();
            this.cbListeSortie.setSelectedIndex(0);
            this.txtChemin.setText(this.parametre.rep_travail);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if ((source == this.rbDebutant || source == this.rbExpert || source == this.rbExploration) && (this.rbDebutant.isSelected() || this.rbExpert.isSelected() || this.rbExploration.isSelected())) {
            this.rbGroupes.setEnabled(true);
            this.rbAtypiques.setEnabled(true);
            this.lblStructure.setEnabled(true);
            this.cbListeSortie.setSelectedItem((Object)EPPLab.msg.getString("cb.listeSortie"));
            this.cbListeSortie.setEnabled(false);
            if ((this.rbGroupes.isSelected() || this.rbAtypiques.isSelected()) && !this.cbListeDonnees.getSelectedItem().equals(EPPLab.msg.getString("cb.listeDonnees"))) {
                this.btOk.setEnabled(true);
            }
        } else if (source == this.rbAnalyse && this.rbAnalyse.isSelected()) {
            this.lblStructure.setEnabled(false);
            this.rbGroupes.setEnabled(false);
            this.rbAtypiques.setEnabled(false);
            this.groupStructure.clearSelection();
            this.lblDonnees.setEnabled(false);
            this.cbListeDonnees.setSelectedItem((Object)EPPLab.msg.getString("cb.listeDonnees"));
            this.cbListeDonnees.setEnabled(false);
            this.btParcourir.setEnabled(false);
            this.cbListeSortie.setEnabled(true);
            this.btOk.setEnabled(false);
        } else if ((source == this.rbGroupes || source == this.rbAtypiques) && (this.rbGroupes.isSelected() || this.rbAtypiques.isSelected())) {
            this.lblDonnees.setEnabled(true);
            this.cbListeDonnees.setEnabled(true);
            this.btParcourir.setEnabled(true);
        }
    }
}

