/*
 * Decompiled with CFR 0.152.
 */
package ihm.controle;

import ihm.Recherche;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import util.GuiUtils;

public final class JTextNbIndividus
extends JTextField
implements CaretListener,
FocusListener {
    private Recherche ctrl;
    private int valeur;
    private boolean erreur;

    public JTextNbIndividus(Recherche c) {
        super(3);
        this.addCaretListener(this);
        this.addFocusListener(this);
        this.ctrl = c;
        this.erreur = false;
        this.valeur = Integer.MAX_VALUE;
    }

    public void setValeur(int i) {
        if (this.valeur != i) {
            this.valeur = i;
            this.setText(Integer.toString(i));
        }
    }

    public void caretUpdate(CaretEvent ce) {
        try {
            int i = Integer.parseInt(this.getText());
            if (i <= 0) {
                throw new NumberFormatException();
            }
            this.setBackground(Color.WHITE);
            this.valeur = i;
            this.ctrl.getParametre().setNbIndividus(i);
            this.erreur = false;
        }
        catch (NumberFormatException nfe) {
            this.setBackground(GuiUtils.BLEU_ERREUR);
            this.erreur = true;
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.erreur) {
            JOptionPane.showMessageDialog(this.ctrl, "Vous devez entrer un nombre entier positif non nul.", "Message", 2);
            this.erreur = false;
            this.requestFocus();
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

