/*
 * Decompiled with CFR 0.152.
 */
package epp;

import epp.EPPLab;
import epp.OrdonnerPP;
import epp.ParametrePP;
import epp.reportToR;
import epp_ag.ChromosomeProj;
import epp_ag.GenomeProj;
import epp_pso.Essaim;
import epp_pso.tribe.EssaimTribe;
import ihm.Recherche;
import indice.Discriminant;
import indice.Friedman;
import indice.FriedmanTukey;
import indice.Indice;
import indice.Indice4;
import indice.KurtosisMax;
import indice.KurtosisMin;
import indice.StahelDonoho;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.StringTokenizer;
import javalain.algorithmegenetique.Population;
import javalain.ea.Evolution;
import javalain.math.Calcul;
import javalain.math.PseudoRandomNumbers;
import math.Matrice;
import util.FileUtils;
import util.GuiUtils;
import util.MsgUtils;
import util.StringUtils;

public class EvolutionPP
extends Evolution {
    private ParametrePP parametre;
    private Indice indice;
    private double[] projection_theorique;
    private StringBuilder sb;
    private int cpt_iteration;
    private int cpt_simulation;
    private int nb_de_jeu_de_donnees;
    private int cpt_jeu_de_donnees;
    private double I;
    private double[] A;
    private double[] tabI;
    private double meilleurI;
    private double meilleurCosinus;
    private double[] meilleureProjectionA;
    private ArrayList<OrdonnerPP> liste;
    private long tempsEcoule;
    private long tempsEstime;
    private double[] tabImax;
    private double[] tabCosImax;
    private double[] tabCmax;
    private Population pop;
    private Essaim swarm;
    private EssaimTribe tribe;
    private double[] X_multistart;
    private Recherche frRecherche;

    public EvolutionPP(ParametrePP p) {
        this.parametre = p;
        this.liste = new ArrayList();
    }

    public void setFrRecherche(Recherche nr) {
        this.frRecherche = nr;
    }

    private void affProjection(double[] A) {
        double[] donnees = new double[this.indice.getMatrice().nbLigne()];
        for (int j = 0; j < this.indice.getMatrice().nbLigne(); ++j) {
            donnees[j] = Calcul.produitScalaireVecteur(this.indice.getMatrice().ligne(j), A);
        }
        this.frRecherche.setGraphique(donnees);
    }

    @Override
    public void demarre() {
        if (this.cpt_iteration == 0 && this.cpt_simulation == 0) {
            Matrice X;
            if (this.frRecherche != null) {
                this.frRecherche.raz();
            }
            String path = this.parametre.rep_donnees + File.separatorChar + this.parametre.ficherDeDonnees;
            if (EPPLab.runsInR) {
                X = new Matrice(EPPLab.dataRows, EPPLab.dataCols);
                int datPosition = 0;
                for (int r = 0; r < EPPLab.dataRows; ++r) {
                    for (int c = 0; c < EPPLab.dataCols; ++c) {
                        double tempValue = EPPLab.dataValues[datPosition];
                        X.setElement(r, c, tempValue);
                        ++datPosition;
                    }
                }
            } else {
                X = new Matrice(path, this.cpt_jeu_de_donnees);
            }
            long start = System.currentTimeMillis();
            Matrice matrice = this.parametre.sphere ? (this.parametre.ficherDeDonnees.equals("fiab_880.txt") ? new Matrice(this.parametre.rep_donnees + File.separatorChar + "fiab_880_sphere.txt") : (this.parametre.ficherDeDonnees.equals("geno_transpose.txt") ? new Matrice(this.parametre.rep_donnees + File.separatorChar + "geno_transpose_sph.txt") : X.spherique())) : X.centreReduite();
            long stop = System.currentTimeMillis();
            matrice.setNom(this.parametre.ficherDeDonnees);
            if (this.parametre.nomIndice == "Kurtosis Max") {
                this.indice = new KurtosisMax(matrice);
            } else if (this.parametre.nomIndice == "Kurtosis Min") {
                this.indice = new KurtosisMin(matrice);
            } else if (this.parametre.nomIndice == "Friedman") {
                this.indice = new Friedman(matrice);
            } else if (this.parametre.nomIndice == "Friedman Tukey") {
                this.indice = new FriedmanTukey(matrice);
            } else if (this.parametre.nomIndice == "Discriminant") {
                this.indice = new Discriminant(matrice);
            } else if (this.parametre.nomIndice == "Indice 4") {
                this.indice = new Indice4(matrice);
            } else if (this.parametre.nomIndice == "Stahel Donoho") {
                this.indice = new StahelDonoho(matrice);
            }
            if (this.cpt_jeu_de_donnees == 0) {
                if (!EPPLab.runsInR) {
                    try {
                        FileReader fichier = new FileReader(path);
                        BufferedReader buffer = new BufferedReader(fichier);
                        StringTokenizer st = new StringTokenizer(buffer.readLine());
                        st.nextToken();
                        int dim = Integer.parseInt(st.nextToken());
                        this.nb_de_jeu_de_donnees = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 1;
                        st = new StringTokenizer(buffer.readLine());
                        if (st.countTokens() != 0) {
                            if (st.countTokens() == dim) {
                                this.projection_theorique = new double[dim];
                                int cpt = 0;
                                while (st.hasMoreTokens()) {
                                    this.projection_theorique[cpt++] = Double.parseDouble(st.nextToken());
                                }
                            } else {
                                MsgUtils.erreurAndExit(null, "Lecture du fichier '" + path + "'.\nLa dimension de la projection th\u00e9orique n'est pas \u00e9gale \u00e0 la dimension de l'espace.", "Programme principal");
                            }
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        MsgUtils.erreurAndExit(null, "Le fichier '" + path + "' est introuvable.", "Programme principal");
                    }
                    catch (IOException ioe) {
                        MsgUtils.erreurAndExit(null, "Probl\u00e8me lors de la lecture du fichier '" + path + "'.", "Programme principal");
                    }
                }
                this.tabImax = new double[this.nb_de_jeu_de_donnees];
                this.tabCosImax = new double[this.nb_de_jeu_de_donnees];
                this.tabCmax = new double[this.nb_de_jeu_de_donnees];
                this.sb = new StringBuilder();
                this.sb.append("<Date_heure>               ").append(DateFormat.getDateTimeInstance(3, 3).format(new Date())).append('\n');
                this.sb.append("<Jeu_de_donnees>           ").append(this.parametre.ficherDeDonnees).append('\n');
                this.sb.append("<Dimension_matrice>        ").append(X.nbLigne()).append(" ").append(X.nbColonne()).append('\n');
                this.sb.append("<Transformation_donnees>   ").append(this.parametre.sphere ? "Spherique" : "Centree_reduite").append('\n');
                this.sb.append("<Indice>                   ").append(this.indice.getClass().getSimpleName()).append('\n');
                this.sb.append("<Dimension_de_projection>  ").append(this.parametre.dimensionProjection).append('\n');
                this.sb.append("<Technique_bimensionnelle> ").append(this.parametre.dimensionProjection == 2 ? "?" : "?").append('\n');
                this.sb.append("<Projection_theorique>     ").append(this.projection_theorique != null ? EvolutionPP.afficheVecteur(this.projection_theorique) : "?").append('\n');
                this.sb.append("<Valeur_de_I>              ").append(this.projection_theorique != null ? GuiUtils.DECIMAL_9.format(this.indice.calcul(this.projection_theorique)) : "?").append('\n');
                this.sb.append("<Methode>                  ").append(this.parametre.methode).append('\n');
                this.sb.append("<Nombre_d_iterations>      ").append(this.parametre.getNbIterations()).append('\n');
                this.sb.append("<Nombre_d_individus>       ").append(this.parametre.methode == "Tribes" ? "?" : Integer.valueOf(this.parametre.getNbIndividus())).append('\n');
                if (this.parametre.methode == "Genetic Algorithm") {
                    this.sb.append(this.parametre.pag);
                } else if (this.parametre.methode == "Particule Swarm Optimization") {
                    this.sb.append(this.parametre.ppso);
                } else if (this.parametre.methode == "Tribes") {
                    this.sb.append(this.parametre.ptribe);
                }
                this.sb.append("<Nombre_de_simulations>    ").append("<nbSimulations>").append("\n\n");
            }
            this.tabI = new double[this.parametre.nbSimulation];
            this.meilleurI = Double.NEGATIVE_INFINITY;
            this.meilleurCosinus = -1.0;
            this.meilleureProjectionA = null;
            this.liste.clear();
            this.sb.append("<Jeu_de_donnees_").append(this.cpt_jeu_de_donnees).append(">\n");
            this.tempsEcoule = 0L;
            this.tempsEstime = 0L;
        }
        if (this.frRecherche != null) {
            this.frRecherche.getCourbeConvergence().raz();
        }
        System.out.print("Simulation " + this.cpt_simulation);
        this.sb.append("<Simulation_").append(this.cpt_simulation).append(">\n");
        if (this.parametre.methode.equals("Genetic Algorithm")) {
            this.pop = new Population(new GenomeProj(this.indice), this.parametre.getNbIndividus(), this.parametre.pag);
            this.pop.initialise();
        } else if (this.parametre.methode.equals("Particule Swarm Optimization")) {
            this.swarm = new Essaim(this.parametre.ppso, this.indice, this.parametre.getNbIndividus());
        } else if (this.parametre.methode.equals("Tribes")) {
            this.tribe = new EssaimTribe(this.indice);
            while (this.cpt_iteration < 2) {
                this.tribe.creationTribu(this.indice);
                this.tribe.updatePbest();
                this.tribe.updatePosition(false, 0);
                ++this.cpt_iteration;
            }
            if (!this.tribe.premiereAdaptation()) {
                this.tribe.creationTribu(this.indice);
            }
        } else if (this.parametre.methode == "MultiStart") {
            this.X_multistart = new double[this.indice.getNombreParametres()];
            for (int i = 0; i < this.indice.getNombreParametres(); ++i) {
                this.X_multistart[i] = PseudoRandomNumbers.random() * 2.0 - 1.0;
            }
            this.X_multistart = Calcul.normaliseVecteur(this.X_multistart);
        }
    }

    @Override
    public void itere() {
        if (this.parametre.methode == "Genetic Algorithm") {
            this.pop.generation();
            this.I = this.pop.getIndividu(this.pop.getPositionMax()).getNote();
            this.A = ((ChromosomeProj)this.pop.getIndividu(this.pop.getPositionMax()).getChromosome(0)).getVecteurProjectionNormalise();
        } else if (this.parametre.methode == "Particule Swarm Optimization") {
            this.swarm.calculMeilleurePosition();
            this.swarm.calculNouvellePosition();
            this.I = this.swarm.getMeilleureParticule().meilleurI;
            this.A = this.swarm.getMeilleureParticule().meilleureProjection;
        } else if (this.parametre.methode == "Tribes") {
            this.tribe.updatePbest();
            this.tribe.updatePosition(false, 0);
            if (this.cpt_iteration == this.tribe.nbLiens() / 2) {
                this.tribe.adaptation(this.indice);
            }
            this.I = this.tribe.getBestParticle().meilleurI;
            this.A = this.tribe.getBestParticle().meilleureProjection;
        } else if (this.parametre.methode == "MultiStart") {
            double[] gradient = ((KurtosisMin)this.indice).gradient(this.X_multistart);
            gradient = Calcul.normaliseVecteur(gradient);
            this.X_multistart = Calcul.differenceVecteur(this.X_multistart, Calcul.multReelVecteur(0.1, gradient));
            this.X_multistart = Calcul.normaliseVecteur(this.X_multistart);
            this.I = this.indice.calcul(this.X_multistart);
            this.A = this.X_multistart;
        }
        if (this.parametre.nbSimulation <= 10) {
            this.sb.append(GuiUtils.DECIMAL_9.format(this.I)).append("\n");
        }
        if (this.frRecherche != null) {
            this.frRecherche.setSimuIterEnCours(this.cpt_simulation, this.cpt_iteration);
            if (this.cpt_simulation == 0) {
                this.tempsEstime = this.getElapsedTime() * (long)this.parametre.getNbIterations() * (long)this.parametre.nbSimulation / (long)(this.cpt_iteration + 1);
            }
            if (this.tempsEcoule + this.getElapsedTime() > 1000L) {
                this.frRecherche.setAffTemps(this.tempsEcoule + this.getElapsedTime(), this.tempsEstime);
            }
            this.frRecherche.getCourbeConvergence().addNombre((float)this.I);
            if (this.frRecherche.isVisuIteration()) {
                this.affProjection(this.A);
            }
        }
    }

    @Override
    public void termine() {
        System.out.print("Friedman 1");
        if (this.getEtatPrecedent() != 0) {
            this.tempsEcoule += this.getElapsedTime();
            this.tempsEstime = (long)this.parametre.nbSimulation * this.tempsEcoule / (long)(this.cpt_simulation + 1);
            if (this.frRecherche != null && this.frRecherche.isVisuLancement()) {
                this.affProjection(this.A);
            }
            this.tabI[this.cpt_simulation] = this.I;
            if (this.I > this.meilleurI) {
                this.meilleurI = this.I;
                this.meilleureProjectionA = this.A;
            }
            this.liste.add(new OrdonnerPP(this.cpt_simulation, this.I, this.A));
            if (this.parametre.nbSimulation == 1) {
                this.sb.append("\n");
            }
            this.sb.append("<I> ").append(GuiUtils.DECIMAL_9.format(this.I)).append("\n");
            this.sb.append("<A> ").append((CharSequence)EvolutionPP.afficheVecteur(this.A)).append("\n");
            if (this.projection_theorique != null) {
                double cos = Math.abs(Calcul.cosinus(this.projection_theorique, this.A));
                if (cos > this.meilleurCosinus) {
                    this.meilleurCosinus = cos;
                }
                this.sb.append("<COS> ").append(cos).append("\n");
            }
            this.sb.append("</Simulation_").append(this.cpt_simulation).append(">\n\n");
            System.out.print("... finished (I " + GuiUtils.DECIMAL_9.format(this.I) + " in " + GuiUtils.DECIMAL_3.format((double)this.getElapsedTime() / 1000.0) + "s)");
            System.out.println("");
        }
        if (!this.isStopUser() && this.cpt_simulation + 1 < this.parametre.nbSimulation) {
            ++this.cpt_simulation;
            if (this.frRecherche != null && this.frRecherche.isStepByStep()) {
                this.setEtat(0);
                this.frRecherche.endStepByStep();
            } else {
                this.setEtat(1);
            }
        } else {
            int j;
            int i;
            int i2;
            if (this.frRecherche != null && this.frRecherche.isVisuFin()) {
                this.affProjection(this.meilleureProjectionA);
            }
            double somme = this.tabI[0];
            for (i2 = 1; i2 <= this.cpt_simulation; ++i2) {
                somme += this.tabI[i2];
            }
            this.sb.append("<Valeur_de_I_moyenne>      ").append(GuiUtils.DECIMAL_9.format(somme / (double)(this.cpt_simulation + 1))).append("\n");
            this.sb.append("<Valeur_de_I_maximale>     ").append(GuiUtils.DECIMAL_9.format(this.meilleurI)).append("\n");
            this.sb.append("<Projection_A>             ").append((CharSequence)EvolutionPP.afficheVecteur(this.meilleureProjectionA)).append("\n");
            if (this.projection_theorique != null) {
                this.sb.append("<Valeur_du_COS_max>        ").append(this.meilleurCosinus).append("\n");
            }
            this.sb.append("\n");
            this.sb.append("<Temps_total>              ").append(StringUtils.convertHMSms(this.tempsEcoule)).append("\n");
            this.sb.append("<Temps_moyen_simulation>   ").append(StringUtils.convertHMSms(this.tempsEcoule / (long)(this.cpt_simulation + 1))).append("\n\n");
            this.sb.append("<NbEVal> ").append(this.indice.getNbEvaluation()).append("\n");
            int nbEC = 3;
            boolean[][] isAtypiques = new boolean[this.liste.size()][this.indice.getMatrice().nbLigne()];
            int nbObs = this.indice.getMatrice().nbLigne();
            int nbLancement = this.liste.size();
            if (this.indice != null && this.liste != null) {
                double[] donnees_x = new double[this.indice.getMatrice().nbLigne()];
                for (i = 0; i < nbLancement; ++i) {
                    for (j = 0; j < nbObs; ++j) {
                        donnees_x[j] = Calcul.produitScalaireVecteur(this.indice.getMatrice().ligne(j), this.liste.get(i).getA());
                    }
                    double ecartType = Calcul.ecartType(donnees_x);
                    double moyenne = Calcul.moyenne(donnees_x);
                    for (j = 0; j < nbObs; ++j) {
                        isAtypiques[i][j] = donnees_x[j] < moyenne - ecartType * (double)nbEC || donnees_x[j] > moyenne + ecartType * (double)nbEC;
                    }
                }
            }
            int ind_atypique = nbObs * 95 / 100;
            int demiNbLancement = nbLancement / 2;
            int M1 = 0;
            double P1 = 0.0;
            for (i = 0; i < nbLancement; ++i) {
                for (j = ind_atypique; j < nbObs; ++j) {
                    if (!isAtypiques[i][j]) continue;
                    ++M1;
                }
            }
            P1 = 100 * M1 / (nbLancement * (nbObs - ind_atypique));
            int M3 = 0;
            double P3 = 0.0;
            for (int i3 = 0; i3 < nbLancement; ++i3) {
                for (int j2 = 0; j2 < ind_atypique; ++j2) {
                    if (!isAtypiques[i3][j2]) continue;
                    ++M3;
                }
            }
            P3 = 100 * M3 / (nbLancement * ind_atypique);
            Collections.sort(this.liste);
            int M2 = 0;
            double P2 = 0.0;
            for (int i4 = 0; i4 < demiNbLancement; ++i4) {
                for (int j3 = ind_atypique; j3 < nbObs; ++j3) {
                    if (!isAtypiques[i4][j3]) continue;
                    ++M2;
                }
            }
            P2 = 100 * M2 / (demiNbLancement * (nbObs - ind_atypique));
            int M4 = 0;
            double P4 = 0.0;
            for (int i5 = 0; i5 < demiNbLancement; ++i5) {
                for (int j4 = 0; j4 < ind_atypique; ++j4) {
                    if (!isAtypiques[i5][j4]) continue;
                    ++M4;
                }
            }
            P4 = 100 * M4 / (demiNbLancement * ind_atypique);
            this.sb.append("<M1> ").append(M1).append(" ").append(P1).append("\n");
            this.sb.append("<M2> ").append(M2).append(" ").append(P2).append("\n");
            this.sb.append("<M3> ").append(M3).append(" ").append(P3).append("\n");
            this.sb.append("<M4> ").append(M4).append(" ").append(P4).append("\n\n");
            this.sb.append("<Les_I>\n");
            for (i2 = 0; i2 <= this.cpt_simulation; ++i2) {
                this.sb.append(GuiUtils.DECIMAL_9.format(this.tabI[i2])).append("\n");
            }
            this.sb.append("</Les_I>\n");
            this.sb.append("</Jeu_de_donnees_").append(this.cpt_jeu_de_donnees).append(">\n\n");
            if (!EPPLab.runsInR) {
                this.tabImax[this.cpt_jeu_de_donnees] = this.meilleurI;
            }
            if (this.projection_theorique != null) {
                this.tabCosImax[this.cpt_jeu_de_donnees] = Math.abs(Calcul.cosinus(this.projection_theorique, this.meilleureProjectionA));
                this.tabCmax[this.cpt_jeu_de_donnees] = this.meilleurCosinus;
            }
            if (!this.isStopUser() && this.cpt_jeu_de_donnees + 1 < this.nb_de_jeu_de_donnees) {
                ++this.cpt_jeu_de_donnees;
                this.setEtat(1);
            } else {
                this.sb.append("<Stats_jeux_de_donnees>\n");
                this.sb.append("<Meilleurs_I>\n");
                if (!EPPLab.runsInR) {
                    for (i2 = 0; i2 <= this.cpt_jeu_de_donnees; ++i2) {
                        this.sb.append(GuiUtils.DECIMAL_9.format(this.tabImax[i2])).append("\n");
                    }
                }
                this.sb.append("</Meilleurs_I>\n");
                if (this.projection_theorique != null) {
                    this.sb.append("<Cosinus_I_max>\n");
                    for (i2 = 0; i2 <= this.cpt_jeu_de_donnees; ++i2) {
                        this.sb.append(GuiUtils.DECIMAL_9.format(this.tabCosImax[i2])).append("\n");
                    }
                    this.sb.append("</Cosinus_I_max>\n");
                    this.sb.append("<Meilleurs_Cos>\n");
                    for (i2 = 0; i2 <= this.cpt_jeu_de_donnees; ++i2) {
                        this.sb.append(GuiUtils.DECIMAL_9.format(this.tabCmax[i2])).append("\n");
                    }
                    this.sb.append("</Meilleurs_Cos>\n");
                }
                this.sb.append("</Stats_jeux_de_donnees>\n\n");
                this.sb = StringUtils.replaceAll(this.sb, "<nbSimulations>", "" + (this.cpt_simulation + 1));
                String nomFichierSortie = "simu_" + (this.cpt_simulation + 1) + "_";
                if (this.parametre.nomIndice == "Friedman") {
                    nomFichierSortie = nomFichierSortie + "F_";
                } else if (this.parametre.nomIndice == "Friedman Tukey") {
                    nomFichierSortie = nomFichierSortie + "FT_";
                } else if (this.parametre.nomIndice == "Kurtosis Max") {
                    nomFichierSortie = nomFichierSortie + "KurtoMax_";
                } else if (this.parametre.nomIndice == "Kurtosis Min") {
                    nomFichierSortie = nomFichierSortie + "KurtoMin_";
                } else if (this.parametre.nomIndice == "Discriminant") {
                    nomFichierSortie = nomFichierSortie + "I3_";
                } else if (this.parametre.nomIndice == "Indice 4") {
                    nomFichierSortie = nomFichierSortie + "I4_";
                } else if (this.parametre.nomIndice == "Stahel Donoho") {
                    nomFichierSortie = nomFichierSortie + "SD_";
                }
                if (this.parametre.methode == "Genetic Algorithm") {
                    nomFichierSortie = nomFichierSortie + "GA_";
                } else if (this.parametre.methode == "Particule Swarm Optimization") {
                    nomFichierSortie = nomFichierSortie + "PSO_";
                } else if (this.parametre.methode == "Tribes") {
                    nomFichierSortie = nomFichierSortie + "TRIBE_";
                } else if (this.parametre.methode == "MultiStart") {
                    nomFichierSortie = nomFichierSortie + "MULTISTART_";
                }
                nomFichierSortie = nomFichierSortie + this.parametre.dimensionProjection + "_";
                nomFichierSortie = nomFichierSortie + this.parametre.ficherDeDonnees;
                reportToR.setResult(this.sb.toString());
                if (this.frRecherche != null) {
                    this.frRecherche.termine(nomFichierSortie);
                } else {
                    File f_temp = new File(this.parametre.rep_sortie + File.separatorChar + nomFichierSortie + ".temp");
                    nomFichierSortie = FileUtils.creeNomFichier(this.parametre.rep_sortie, nomFichierSortie);
                    f_temp.renameTo(new File(this.parametre.rep_sortie + File.separatorChar + nomFichierSortie));
                }
                this.cpt_jeu_de_donnees = 0;
            }
            this.cpt_simulation = 0;
        }
        this.cpt_iteration = 0;
    }

    @Override
    public boolean conditionEvolution() {
        return ++this.cpt_iteration < this.parametre.getNbIterations();
    }

    public static StringBuilder afficheVecteur(double[] a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < a.length - 1; ++i) {
            sb.append(GuiUtils.DECIMAL_9.format(a[i])).append(" ");
        }
        sb.append(GuiUtils.DECIMAL_9.format(a[a.length - 1]));
        return sb;
    }
}

