/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

public class ArithmeticMod {
    private static final double two17 = 131072.0;
    private static final double two53 = 9.007199254740992E15;

    private ArithmeticMod() {
    }

    public static double multModM(double d, double d2, double d3, double d4) {
        double d5;
        int n;
        double d6 = d * d2 + d3;
        if (d6 >= 9.007199254740992E15 || d6 <= -9.007199254740992E15) {
            n = (int)(d / 131072.0);
            d -= (double)n * 131072.0;
            d6 = (double)n * d2;
            n = (int)(d6 / d4);
            d6 -= (double)n * d4;
            d6 = d6 * 131072.0 + d * d2 + d3;
        }
        n = (int)(d6 / d4);
        d6 -= (double)n * d4;
        if (d5 < 0.0) {
            return d6 += d4;
        }
        return d6;
    }

    public static void matVecModM(double[][] dArray, double[] dArray2, double[] dArray3, double d) {
        int n;
        double[] dArray4 = new double[dArray3.length];
        for (n = 0; n < dArray3.length; ++n) {
            dArray4[n] = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                dArray4[n] = ArithmeticMod.multModM(dArray[n][i], dArray2[i], dArray4[n], d);
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = dArray4[n];
        }
    }

    public static void matMatModM(double[][] dArray, double[][] dArray2, double[][] dArray3, double d) {
        int n;
        int n2;
        int n3 = dArray3.length;
        int n4 = dArray3[0].length;
        double[] dArray4 = new double[n3];
        double[][] dArray5 = new double[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray4[n] = dArray2[n][n2];
            }
            ArithmeticMod.matVecModM(dArray, dArray4, dArray4, d);
            for (n = 0; n < n3; ++n) {
                dArray5[n][n2] = dArray4[n];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                dArray3[n2][n] = dArray5[n2][n];
            }
        }
    }

    public static void matTwoPowModM(double[][] dArray, double[][] dArray2, double d, int n) {
        int n2;
        if (dArray != dArray2) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[n2][i] = dArray[n2][i];
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            ArithmeticMod.matMatModM(dArray2, dArray2, dArray2, d);
        }
    }

    public static void matPowModM(double[][] dArray, double[][] dArray2, double d, int n) {
        int n2;
        int n3 = n;
        int n4 = dArray.length;
        double[][] dArray3 = new double[n4][n4];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                dArray3[i][n2] = dArray[i][n2];
                dArray2[i][n2] = 0.0;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray2[n2][n2] = 1.0;
        }
        while (n3 > 0) {
            if (n3 % 2 == 1) {
                ArithmeticMod.matMatModM(dArray3, dArray2, dArray2, d);
            }
            ArithmeticMod.matMatModM(dArray3, dArray3, dArray3, d);
            n3 /= 2;
        }
    }

    public static int multModM(int n, int n2, int n3, int n4) {
        int n5 = (int)(((long)n * (long)n2 + (long)n3) % (long)n4);
        return n5 < 0 ? n5 + n4 : n5;
    }

    public static void matVecModM(int[][] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        int[] nArray4 = new int[nArray3.length];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray4[n2] = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                nArray4[n2] = ArithmeticMod.multModM(nArray[n2][i], nArray2[i], nArray4[n2], n);
            }
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = nArray4[n2];
        }
    }

    public static void matMatModM(int[][] nArray, int[][] nArray2, int[][] nArray3, int n) {
        int n2;
        int n3;
        int n4 = nArray3.length;
        int n5 = nArray3[0].length;
        int[] nArray4 = new int[n4];
        int[][] nArray5 = new int[n4][n5];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                nArray4[n2] = nArray2[n2][n3];
            }
            ArithmeticMod.matVecModM(nArray, nArray4, nArray4, n);
            for (n2 = 0; n2 < n4; ++n2) {
                nArray5[n2][n3] = nArray4[n2];
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                nArray3[n3][n2] = nArray5[n3][n2];
            }
        }
    }

    public static void matTwoPowModM(int[][] nArray, int[][] nArray2, int n, int n2) {
        int n3;
        if (nArray != nArray2) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[n3][i] = nArray[n3][i];
                }
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            ArithmeticMod.matMatModM(nArray2, nArray2, nArray2, n);
        }
    }

    public static void matPowModM(int[][] nArray, int[][] nArray2, int n, int n2) {
        int n3;
        int n4 = n2;
        int n5 = nArray.length;
        int[][] nArray3 = new int[n5][n5];
        for (int i = 0; i < n5; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                nArray3[i][n3] = nArray[i][n3];
                nArray2[i][n3] = 0;
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            nArray2[n3][n3] = 1;
        }
        while (n4 > 0) {
            if (n4 % 2 == 1) {
                ArithmeticMod.matMatModM(nArray3, nArray2, nArray2, n);
            }
            ArithmeticMod.matMatModM(nArray3, nArray3, nArray3, n);
            n4 /= 2;
        }
    }

    public static long multModM(long l, long l2, long l3, long l4) {
        long l5;
        long l6;
        long l7;
        long l8;
        if (l < 0x80000000L) {
            l8 = l;
            l7 = 0L;
        } else {
            long l9 = l / 0x80000000L;
            l8 = l - 0x80000000L * l9;
            long l10 = l4 / 0x80000000L;
            long l11 = l4 - 0x80000000L * l10;
            if (l9 >= 0x80000000L) {
                l9 -= 0x80000000L;
                l6 = l2 / l10;
                l7 = 0x80000000L * (l2 - l6 * l10) - l6 * l11;
                if (l7 < 0L) {
                    l7 = (l7 + 1L) % l4 + l4 - 1L;
                }
            } else {
                l7 = 0L;
            }
            if (l9 != 0L) {
                l5 = l4 / l9;
                l6 = l2 / l5;
                if ((l7 -= l6 * (l4 - l9 * l5)) > 0L) {
                    l7 -= l4;
                }
                if ((l7 += l9 * (l2 - l6 * l5)) < 0L) {
                    l7 = (l7 + 1L) % l4 + l4 - 1L;
                }
            }
            if ((l7 = 0x80000000L * (l7 - (l6 = l7 / l10) * l10) - l6 * l11) < 0L) {
                l7 = (l7 + 1L) % l4 + l4 - 1L;
            }
        }
        if (l8 != 0L) {
            l5 = l4 / l8;
            l6 = l2 / l5;
            if ((l7 -= l6 * (l4 - l8 * l5)) > 0L) {
                l7 -= l4;
            }
            if ((l7 += l8 * (l2 - l6 * l5)) < 0L) {
                l7 = (l7 + 1L) % l4 + l4 - 1L;
            }
        }
        if ((l7 = l7 - l4 + l3) < 0L) {
            l7 += l4;
        }
        return l7;
    }

    public static void matVecModM(long[][] lArray, long[] lArray2, long[] lArray3, long l) {
        int n;
        long[] lArray4 = new long[lArray3.length];
        for (n = 0; n < lArray3.length; ++n) {
            lArray4[n] = 0L;
            for (int i = 0; i < lArray2.length; ++i) {
                lArray4[n] = ArithmeticMod.multModM(lArray[n][i], lArray2[i], lArray4[n], l);
            }
        }
        for (n = 0; n < lArray3.length; ++n) {
            lArray3[n] = lArray4[n];
        }
    }

    public static void matMatModM(long[][] lArray, long[][] lArray2, long[][] lArray3, long l) {
        int n;
        int n2;
        int n3 = lArray3.length;
        int n4 = lArray3[0].length;
        long[] lArray4 = new long[n3];
        long[][] lArray5 = new long[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                lArray4[n] = lArray2[n][n2];
            }
            ArithmeticMod.matVecModM(lArray, lArray4, lArray4, l);
            for (n = 0; n < n3; ++n) {
                lArray5[n][n2] = lArray4[n];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                lArray3[n2][n] = lArray5[n2][n];
            }
        }
    }

    public static void matTwoPowModM(long[][] lArray, long[][] lArray2, long l, int n) {
        int n2;
        if (lArray != lArray2) {
            for (n2 = 0; n2 < lArray.length; ++n2) {
                for (int i = 0; i < lArray.length; ++i) {
                    lArray2[n2][i] = lArray[n2][i];
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            ArithmeticMod.matMatModM(lArray2, lArray2, lArray2, l);
        }
    }

    public static void matPowModM(long[][] lArray, long[][] lArray2, long l, int n) {
        int n2;
        int n3 = n;
        int n4 = lArray.length;
        long[][] lArray3 = new long[n4][n4];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                lArray3[i][n2] = lArray[i][n2];
                lArray2[i][n2] = 0L;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            lArray2[n2][n2] = 1L;
        }
        while (n3 > 0) {
            if (n3 % 2 == 1) {
                ArithmeticMod.matMatModM(lArray3, lArray2, lArray2, l);
            }
            ArithmeticMod.matMatModM(lArray3, lArray3, lArray3, l);
            n3 /= 2;
        }
    }
}

