/*
 * Decompiled with CFR 0.152.
 */
package epp_pso.tribes_new;

import indice.Indice;
import javalain.math.Calcul;
import javalain.math.PseudoRandomNumbers;
import util.GuiUtils;

public class ParticuleTribes_new {
    private static double EPS = 1.0E-14;
    private static final int AMELIORATION = 0;
    private static final int STATU_QUO = 1;
    private static final int DETERIORATION = 2;
    private static final int BONNE = 5;
    private static final int NEUTRE = 6;
    private final Indice indice;
    private final int P;
    private double I;
    public double meilleurI;
    private double[] projection;
    public double[] meilleureProjection;
    private int evolPerfPrec;
    private int evolPerf;
    private int qualite;

    public ParticuleTribes_new(Indice ind) {
        this.indice = ind;
        this.P = ind.getNombreParametres();
        this.projection = new double[this.P];
        this.meilleureProjection = new double[this.P];
        for (int i = 0; i < this.P; ++i) {
            this.projection[i] = PseudoRandomNumbers.random() * 2.0 - 1.0;
        }
        this.projection = Calcul.normaliseVecteur(this.projection);
        this.meilleurI = this.I = this.indice.calcul(this.projection);
        System.arraycopy(this.projection, 0, this.meilleureProjection, 0, this.P);
        this.evolPerfPrec = 1;
        this.evolPerf = 1;
        this.qualite = 6;
    }

    private ParticuleTribes_new(ParticuleTribes_new p) {
        this.indice = p.indice;
        this.P = p.P;
        this.projection = new double[this.P];
        this.meilleureProjection = new double[this.P];
        System.arraycopy(p.projection, 0, this.projection, 0, this.P);
        System.arraycopy(p.meilleureProjection, 0, this.meilleureProjection, 0, this.P);
        this.I = p.I;
        this.meilleurI = p.meilleurI;
        this.evolPerfPrec = p.evolPerfPrec;
        this.evolPerf = p.evolPerf;
        this.qualite = p.qualite;
    }

    public ParticuleTribes_new(Indice ind, ParticuleTribes_new bestParticuleOfSwarm, ParticuleTribes_new bestParticuleOfTribe) {
        this.indice = ind;
        this.P = ind.getNombreParametres();
        this.projection = Calcul.loiHyperspherique(bestParticuleOfSwarm.meilleureProjection, bestParticuleOfTribe.meilleureProjection);
        this.meilleureProjection = new double[this.P];
        this.projection = Calcul.normaliseVecteur(this.projection);
        this.meilleurI = this.I = this.indice.calcul(this.projection);
        System.arraycopy(this.projection, 0, this.meilleureProjection, 0, this.P);
        this.evolPerfPrec = 1;
        this.evolPerf = 1;
        this.qualite = 6;
    }

    public boolean isGood() {
        return this.qualite == 5;
    }

    public ParticuleTribes_new createCopie() {
        return new ParticuleTribes_new(this);
    }

    public void updatePosition(ParticuleTribes_new informatrice) {
        if (this.evolPerfPrec == 2 && this.evolPerf == 2 || this.evolPerfPrec == 1 && this.evolPerf == 2 || this.evolPerfPrec == 2 && this.evolPerf == 1 || this.evolPerfPrec == 1 && this.evolPerf == 1 || this.evolPerfPrec == 0 && this.evolPerf == 2) {
            this.pivot(informatrice);
        }
        if (this.evolPerfPrec == 0 && this.evolPerf == 1 || this.evolPerfPrec == 2 && this.evolPerf == 0) {
            this.pivotBruite(informatrice);
        }
        if (this.evolPerfPrec == 1 && this.evolPerf == 0 || this.evolPerfPrec == 0 && this.evolPerf == 0) {
            this.gaussienneIndependante(informatrice);
        }
        this.projection = Calcul.normaliseVecteur(this.projection);
    }

    public void updateBest() {
        double d = this.I;
        this.I = this.indice.calcul(this.projection);
        this.evolPerfPrec = this.evolPerf;
        if (this.I > this.meilleurI) {
            this.meilleurI = this.I;
            System.arraycopy(this.projection, 0, this.meilleureProjection, 0, this.P);
            this.qualite = 5;
            this.evolPerf = 0;
        } else {
            this.qualite = 6;
        }
    }

    private void pivot(ParticuleTribes_new informatrice) {
        double somme = this.meilleurI + informatrice.meilleurI;
        double c2 = somme < EPS ? PseudoRandomNumbers.random() : this.meilleurI / somme;
        double c3 = 1.0 - c2;
        double[] alea_Hp = Calcul.loiHyperspherique(this.meilleureProjection, informatrice.meilleureProjection);
        double[] alea_Hg = Calcul.loiHyperspherique(informatrice.meilleureProjection, this.meilleureProjection);
        for (int i = 0; i < this.P; ++i) {
            this.projection[i] = c2 * alea_Hp[i] + c3 * alea_Hg[i];
        }
    }

    private void pivotBruite(ParticuleTribes_new informatrice) {
        double somme = this.meilleurI + informatrice.meilleurI;
        double c2 = somme < EPS ? PseudoRandomNumbers.random() : this.meilleurI / somme;
        double c3 = 1.0 - c2;
        double[] alea_Hp = Calcul.loiHyperspherique(this.meilleureProjection, informatrice.meilleureProjection);
        double[] alea_Hg = Calcul.loiHyperspherique(informatrice.meilleureProjection, this.meilleureProjection);
        for (int i = 0; i < this.P; ++i) {
            this.projection[i] = c2 * alea_Hp[i] + c3 * alea_Hg[i];
        }
        double sigma = somme < EPS ? 1.0 : (this.meilleurI - informatrice.meilleurI) / somme;
        double c = Calcul.loiNormale(0.0, sigma);
        for (int i = 0; i < this.P; ++i) {
            this.projection[i] = (1.0 + c) * this.projection[i];
        }
    }

    private void gaussienneIndependante(ParticuleTribes_new informatrice) {
        for (int i = 0; i < this.P; ++i) {
            double d = informatrice.meilleureProjection[i] - this.projection[i];
            double sigma = Math.abs(informatrice.meilleureProjection[i] - this.projection[i]);
            this.projection[i] = this.meilleureProjection[i] + Calcul.loiNormale(d, sigma);
        }
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("----- Particule (").append(this.P).append(")\n");
        s.append("Performance          : ").append(GuiUtils.DECIMAL_12.format(this.I)).append("\n");
        s.append("Meilleur performance : ").append(GuiUtils.DECIMAL_12.format(this.meilleurI)).append("\n");
        s.append("Position             : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.projection[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.projection[this.P - 1])).append("\n");
        s.append("Meilleure position   : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[this.P - 1])).append("\n");
        s.append("-----");
        return s.toString();
    }
}

