/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import cern.colt.list.DoubleArrayList;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandomStreamWithCache
implements RandomStream {
    private RandomStream stream;
    private DoubleArrayList values;
    private int index = 0;
    private boolean caching = true;

    public RandomStreamWithCache(RandomStream randomStream) {
        if (randomStream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        this.stream = randomStream;
        this.values = new DoubleArrayList();
    }

    public RandomStreamWithCache(RandomStream randomStream, int n) {
        if (randomStream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        this.stream = randomStream;
        this.values = new DoubleArrayList(n);
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean bl) {
        if (this.caching && !bl) {
            this.clearCache();
        }
        this.caching = bl;
    }

    public RandomStream getCachedStream() {
        return this.stream;
    }

    public void setCachedStream(RandomStream randomStream) {
        if (randomStream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        if (randomStream == this.stream) {
            return;
        }
        this.stream = randomStream;
        this.clearCache();
    }

    public void clearCache() {
        this.values = new DoubleArrayList();
        this.index = 0;
    }

    public void initCache() {
        this.index = 0;
    }

    public int getNumCachedValues() {
        return this.values.size();
    }

    public int getCacheIndex() {
        return this.index;
    }

    public void setCacheIndex(int n) {
        if (n < 0 || n > this.values.size()) {
            throw new IllegalArgumentException("newIndex must not be negative or greater than the cache size");
        }
        this.index = n;
    }

    public DoubleArrayList getCachedValues() {
        return this.values;
    }

    public void setCachedValues(DoubleArrayList doubleArrayList) {
        if (doubleArrayList == null) {
            throw new NullPointerException();
        }
        this.values = doubleArrayList;
        this.index = doubleArrayList.size();
    }

    public void resetStartStream() {
        this.stream.resetStartStream();
    }

    public void resetStartSubstream() {
        this.stream.resetStartSubstream();
    }

    public void resetNextSubstream() {
        this.stream.resetNextSubstream();
    }

    public double nextDouble() {
        if (!this.caching) {
            return this.stream.nextDouble();
        }
        if (this.index >= this.values.size()) {
            double d = this.stream.nextDouble();
            this.values.add(d);
            ++this.index;
            return d;
        }
        return this.values.getQuick(this.index++);
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        if (!this.caching) {
            this.stream.nextArrayOfDouble(dArray, n, n2);
            return;
        }
        int n5 = this.values.size() - this.index;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n4 = Math.min(n2, n5)) > 0) {
            System.arraycopy(this.values.elements(), this.index, dArray, n, n4);
            this.index += n4;
        }
        if ((n3 = n2 - n4) > 0) {
            this.stream.nextArrayOfDouble(dArray, n + n4, n3);
            for (int i = n4; i < n2; ++i) {
                this.values.add(dArray[n + i]);
                ++this.index;
            }
        }
    }

    public int nextInt(int n, int n2) {
        return n + (int)(this.nextDouble() * (double)(n2 - n + 1));
    }

    public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
        for (int i = n3; i < n3 + n4; ++i) {
            nArray[i] = this.nextInt(n, n2);
        }
    }
}

